<?php
/**
 * DeepMax.ru Utility Functions
 * 
 * Версия: 2.1.0 LOGS_MIGRATION
 * Дата: 2025-10-25
 * 
 * ИЗМЕНЕНИЯ v2.1.0:
 *   ✅ FIX: Короткий тег <? заменён на <?php (ПРАВИЛО 30)
 *   ✅ MIGRATION: Функции my_log(), input_log(), my_error_log()
 *                 теперь используют новую систему логирования (logs.php)
 *   ✅ SAFE: Весь остальной код без изменений
 * 
 * МИГРАЦИЯ:
 *   Старые вызовы my_log($msg) продолжают работать,
 *   но пишут в новые файлы с датами: log_2025-10-25.txt
 */

/**
 * Записать сообщение в основной лог
 * 
 * v2.1.0: Использует новую систему логирования (logs.php)
 * Автоматическая ротация по датам, хранение 7 дней
 * 
 * @param string $message Сообщение для логирования
 */
function my_log($message){
   require_once __DIR__ . '/logs.php';
   writeLog($message, 'log');
}

/**
 * Записать сообщение в лог входных данных
 * 
 * v2.1.0: Использует новую систему логирования (logs.php)
 * 
 * @param string $message Сообщение для логирования
 */
function input_log($message){
   require_once __DIR__ . '/logs.php';
   writeLog($message, 'input');
}

/**
 * Записать сообщение в лог ошибок
 * 
 * v2.1.0: Использует новую систему логирования (logs.php)
 * 
 * @param string $message Сообщение для логирования
 */
function my_error_log($message){
   require_once __DIR__ . '/logs.php';
   writeLog($message, 'error');
}

function print_r_pre($mixed){
   echo '<pre>';
   print_r($mixed);
   echo '</pre>';
}

// Разделяет разряды чисел пробелами
function number_divide_space($number){
   $number = strval($number);
   if(strlen($number) == 0 || $number == ' '){
      return '';
   }
   $end = '';
   //Есть точка
   $dot_pos = strpos($number, '.');
   if ($dot_pos === false){
      $dot_pos = strpos($number, ',');
   }
   if ($dot_pos !== false){
      $end = substr($number, $dot_pos);
      if(strlen($end) < 3){
         $end = $end . '0';
      }
      $number = substr($number, 0, $dot_pos);
   }else{
      $dot_pos = strlen($number);
   }
   if(strlen($end) == 0){
      $end = '.00';
   }
   //Добавляет пробелы через каждые 3 символа
   $new_number = '';
   $count = 0;
   $last_i = $dot_pos;
   for($i = strlen($number)-1; $i >= 1; $i--){
      $count = $count + 1;
      if ($count == 3){
         $new_number = ' ' . substr($number, $i, 3) . $new_number;
         $count = 0;
         $last_i = $i;
      }
   }
   $new_number = substr($number, 0, $last_i) . $new_number;
   
   return $new_number . $end;
}

function get_page_url(){
   $url_parts = explode('/', $_SERVER['REQUEST_URI']);
   $url = '';
   if(count($url_parts) > 1){
      $url = $url_parts[1];
   }
   return $url_parts;
}