<?php
/**
 * menu.php v8.0 REDESIGN
 * 
 * DeepMax.ru - Main Navigation Menu with Modern Design
 * Date: 2025-11-10
 * Status: PRODUCTION READY
 * 
 * Changelog v8.0 REDESIGN:
 * - NEW: Modern dark gradient design
 * - NEW: SVG icons for each menu item
 * - NEW: Animated menu items (slideIn effect)
 * - NEW: Menu categories with subitems
 * - NEW: Close button in menu header
 * - NEW: Menu footer with contacts
 * - IMPROVED: Better mobile UX with smooth animations
 * - IMPROVED: Custom scrollbar styling
 * - PRESERVED: All PHP logic from v7.1
 * - PRESERVED: Accessibility features (ARIA, keyboard nav)
 * 
 * Previous version: v7.1 PAGE_URL_FALLBACK
 */

// v7.1 PAGE_URL_FALLBACK: Fallback для $page_url если не определена в global scope
if (!isset($page_url)) {
    $page_url = trim($_SERVER['REQUEST_URI'] ?? '/', '/');
}
?>

<nav class="main-nav" aria-label="Главное меню">
    <!-- Mobile toggle button -->
    <button class="menu-button" type="button" aria-label="Открыть меню" aria-expanded="false">
        <span></span>
        <span></span>
        <span></span>
    </button>
    
    <!-- Site title (visible on mobile) -->
    <div class="site-title-mobile"><?php echo htmlspecialchars(SITE_NAME); ?></div>
</nav>

<!-- Mobile menu overlay -->
<div class="menu-overlay" aria-hidden="true"></div>

<!-- Menu Container -->
<div class="menu-container">
    <!-- Menu Header -->
    <div class="menu-header">
        <div class="menu-logo"><?php echo htmlspecialchars(SITE_NAME); ?></div>
        <button class="close-button" type="button" aria-label="Закрыть меню">×</button>
    </div>
    
    <!-- Menu Items -->
    <div class="menu-section">
        <?php
        // Главная страница
        $is_home = (empty($page_url) || $page_url == '/' || $page_url == 'index');
        $home_class = $is_home ? ' active' : '';
        $home_aria = $is_home ? ' aria-current="page"' : '';
        $home_title = 'Главная страница ' . htmlspecialchars(SITE_NAME);
        ?>
        
        <a href="/" class="menu-item<?php echo $home_class; ?>" role="menuitem"<?php echo $home_aria; ?> title="<?php echo $home_title; ?>">
            <div class="menu-icon">
                <svg fill="currentColor" viewBox="0 0 24 24">
                    <path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z"/>
                </svg>
            </div>
            <span>Главная</span>
        </a>
    </div>
    
    <div class="menu-divider"></div>
    
    <?php
    // Получаем пункты меню из БД
    $menu_items = getMenuItems();
    
    // Группируем по типам (если нужно)
    $instruments = [];
    $sectors = [];
    $other = [];
    
    if (!empty($menu_items)) {
        foreach ($menu_items as $item) {
            $clean_url = trim($item->MENU_url, '/');
            $name = $item->MENU_name;
            
            // Простая логика группировки по именам
            if (stripos($name, 'акции') !== false || stripos($name, 'stock') !== false) {
                $instruments[] = $item;
            } elseif (stripos($name, 'облигации') !== false || stripos($name, 'bond') !== false) {
                $instruments[] = $item;
            } elseif (stripos($name, 'эмитент') !== false) {
                $instruments[] = $item;
            } elseif (stripos($name, 'сектор') !== false) {
                $sectors[] = $item;
            } else {
                $other[] = $item;
            }
        }
    }
    ?>
    
    <?php if (!empty($sectors)): ?>
    <!-- Секция: Сектора -->
    <div class="menu-section">
        <div class="menu-category">Сектора</div>
        <?php foreach ($sectors as $item): 
            $clean_url = trim($item->MENU_url, '/');
            $url = '/' . htmlspecialchars($clean_url) . '/';
            $name = htmlspecialchars($item->MENU_name);
            $is_current = ($clean_url == trim($page_url, '/'));
            $item_class = $is_current ? ' active' : '';
            $aria_current = $is_current ? ' aria-current="page"' : '';
            $title = htmlspecialchars('Перейти в раздел: ' . $item->MENU_name);
        ?>
        <a href="<?php echo $url; ?>" class="menu-item<?php echo $item_class; ?>" role="menuitem"<?php echo $aria_current; ?> title="<?php echo $title; ?>">
            <div class="menu-icon">
                <svg fill="currentColor" viewBox="0 0 24 24">
                    <path d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm.5-13H11v6l5.25 3.15.75-1.23-4.5-2.67z"/>
                </svg>
            </div>
            <span><?php echo $name; ?></span>
        </a>
        <?php endforeach; ?>
    </div>
    
    <div class="menu-divider"></div>
    <?php endif; ?>
    
    <?php if (!empty($instruments)): ?>
    <!-- Секция: Инструменты -->
    <div class="menu-section">
        <div class="menu-category">Инструменты</div>
        <?php foreach ($instruments as $item): 
            $clean_url = trim($item->MENU_url, '/');
            $url = '/' . htmlspecialchars($clean_url) . '/';
            $name = htmlspecialchars($item->MENU_name);
            $is_current = ($clean_url == trim($page_url, '/'));
            $item_class = $is_current ? ' active' : '';
            $aria_current = $is_current ? ' aria-current="page"' : '';
            $title = htmlspecialchars('Перейти в раздел: ' . $item->MENU_name);
            
            // Выбор иконки
            $icon_svg = '';
            if (stripos($name, 'акции') !== false || stripos($name, 'stock') !== false) {
                // Иконка: график акций
                $icon_svg = '<path d="M16 6l2.29 2.29-4.88 4.88-4-4L2 16.59 3.41 18l6-6 4 4 6.3-6.29L22 12V6z"/>';
            } elseif (stripos($name, 'облигации') !== false || stripos($name, 'bond') !== false) {
                // Иконка: деньги
                $icon_svg = '<path d="M11.8 10.9c-2.27-.59-3-1.2-3-2.15 0-1.09 1.01-1.85 2.7-1.85 1.78 0 2.44.85 2.5 2.1h2.21c-.07-1.72-1.12-3.3-3.21-3.81V3h-3v2.16c-1.94.42-3.5 1.68-3.5 3.61 0 2.31 1.91 3.46 4.7 4.13 2.5.6 3 1.48 3 2.41 0 .69-.49 1.79-2.7 1.79-2.06 0-2.87-.92-2.98-2.1h-2.2c.12 2.19 1.76 3.42 3.68 3.83V21h3v-2.15c1.95-.37 3.5-1.5 3.5-3.55 0-2.84-2.43-3.81-4.7-4.4z"/>';
            } elseif (stripos($name, 'эмитент') !== false) {
                // Иконка: здание
                $icon_svg = '<path d="M21 18v1c0 1.1-.9 2-2 2H5c-1.11 0-2-.9-2-2V5c0-1.1.89-2 2-2h14c1.1 0 2 .9 2 2v1h-9c-1.11 0-2 .9-2 2v8c0 1.1.89 2 2 2h9zm-9-2h10V8H12v8zm4-2.5c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5z"/>';
            } else {
                // Иконка по умолчанию
                $icon_svg = '<path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>';
            }
        ?>
        <a href="<?php echo $url; ?>" class="menu-item<?php echo $item_class; ?>" role="menuitem"<?php echo $aria_current; ?> title="<?php echo $title; ?>">
            <div class="menu-icon">
                <svg fill="currentColor" viewBox="0 0 24 24">
                    <?php echo $icon_svg; ?>
                </svg>
            </div>
            <span><?php echo $name; ?></span>
        </a>
        <?php endforeach; ?>
    </div>
    
    <div class="menu-divider"></div>
    <?php endif; ?>
    
    <?php if (!empty($other)): ?>
    <!-- Секция: Остальное -->
    <div class="menu-section">
        <?php foreach ($other as $item): 
            $clean_url = trim($item->MENU_url, '/');
            $url = '/' . htmlspecialchars($clean_url) . '/';
            $name = htmlspecialchars($item->MENU_name);
            $is_current = ($clean_url == trim($page_url, '/'));
            $item_class = $is_current ? ' active' : '';
            $aria_current = $is_current ? ' aria-current="page"' : '';
            $title = htmlspecialchars('Перейти в раздел: ' . $item->MENU_name);
            
            // Иконка по умолчанию
            $icon_svg = '<path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/>';
        ?>
        <a href="<?php echo $url; ?>" class="menu-item<?php echo $item_class; ?>" role="menuitem"<?php echo $aria_current; ?> title="<?php echo $title; ?>">
            <div class="menu-icon">
                <svg fill="currentColor" viewBox="0 0 24 24">
                    <?php echo $icon_svg; ?>
                </svg>
            </div>
            <span><?php echo $name; ?></span>
        </a>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>
    
    <!-- Menu Footer -->
    <div class="menu-footer">
        <div class="menu-footer-text">
            © <?php echo date('Y'); ?> <?php echo htmlspecialchars(SITE_NAME); ?><br>
            Информационный портал о ценных бумагах
        </div>
        <div class="menu-footer-info">
            <p><strong>Email:</strong> info@deepmax.ru</p>
            <p><strong>Поддержка:</strong> support@deepmax.ru</p>
            <p><strong>Время работы:</strong></p>
            <p>Пн-Пт 9:00-18:00</p>
        </div>
    </div>
</div>