<?php
/**
 * ═══════════════════════════════════════════════════════════════════════════
 * СТРАНИЦА: ИНСТРУМЕНТЫ БЕЗ ДАННЫХ QUIK v4.0.0 EMITENT-STYLE
 * ═══════════════════════════════════════════════════════════════════════════
 * 
 * Версия: 4.0.0 EMITENT-STYLE
 * Дата: 2025-10-20
 * Статус: PRODUCTION READY ✅
 * ИЗМЕНЕНИЯ v4.0.0:
 *   ✅ NEW: Структура КАК в emitent.php
 *   ✅ NEW: Кликабельные метрики по типам с анкорами
 *   ✅ NEW: 6 разделов по типам инструментов
 *   ✅ NEW: Группировка по эмитентам внутри каждого типа
 *   ✅ REMOVED: Сектора экономики (не нужны)
 * 
 * НАЗНАЧЕНИЕ:
 *   Техническая страница для анализа данных БД
 *   Показывает все инструменты из таблицы Instrument, 
 *   у которых НЕТ данных в таблицах QUIK_Akcii и QUIK_Obligacii
 * 
 * СТРУКТУРА:
 *   Hero → Метрики (6 типов) → Разделы (1-6) → Эмитенты → Карточки
 * 
 * ТРЕБУЕТ:
 *   - DB/db.php
 *   - best.css v7.9.2+
 *   - PHP 8.1+
 * 
 * ⚠️ ВАЖНО: Это служебная страница, не для публичного доступа
 * 
 * ═══════════════════════════════════════════════════════════════════════════
 */

// ═══════════════════════════════════════════════════════════════════════════
// ПРОВЕРКА ЗАВИСИМОСТЕЙ
// ═══════════════════════════════════════════════════════════════════════════

if (!function_exists('esc')) {
    function esc($value) {
        if (is_null($value)) return '';
        return htmlspecialchars((string)$value, ENT_QUOTES, 'UTF-8');
    }
}

// ═══════════════════════════════════════════════════════════════════════════
// ПОЛУЧЕНИЕ ДАННЫХ ИЗ БД
// ═══════════════════════════════════════════════════════════════════════════

global $db;

$instruments_no_data = [];
$total_count = 0;

// SQL запрос: все инструменты БЕЗ данных в QUIK таблицах
$sql = "
    SELECT 
        i.*,
        e.Id as Emitent_Id,
        e.EMITENT_SHORT_NAME,
        e.EMITENT_FULL_NAME
    FROM Instrument i
    LEFT JOIN Emitent e ON i.Emitent_Id = e.Id
    LEFT JOIN QUIK_Akcii qa 
        ON i.Instrument_ISIN = qa.ISIN 
        AND i.Instrument_SUPERTYPE_ID IN (1, 2, 4)
    LEFT JOIN QUIK_Obligacii qo 
        ON i.Instrument_ISIN = qo.ISIN 
        AND i.Instrument_SUPERTYPE_ID IN (3, 5, 6)
    WHERE 
        qa.SecCode IS NULL 
        AND qo.SecCode IS NULL
    ORDER BY 
        i.Instrument_SUPERTYPE_ID,
        e.EMITENT_SHORT_NAME,
        i.Instrument_TRADE_CODE
";

$result = $db->connection->query($sql);

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $instruments_no_data[] = $row;
        $total_count++;
    }
}

// ═══════════════════════════════════════════════════════════════════════════
// ГРУППИРОВКА: Тип → Эмитент → Инструменты
// ═══════════════════════════════════════════════════════════════════════════

$instrumentsByType = [
    1 => [],
    2 => [],
    3 => [],
    4 => [],
    5 => [],
    6 => []
];

foreach ($instruments_no_data as $inst) {
    $type_id = (int)($inst['Instrument_SUPERTYPE_ID'] ?? 0);
    
    // Пропускаем если тип неизвестен
    if (!isset($instrumentsByType[$type_id])) continue;
    
    $emitent_name = $inst['EMITENT_SHORT_NAME'] ?? $inst['EMITENT_FULL_NAME'] ?? 'Эмитент не указан';
    $emitent_id = $inst['Emitent_Id'] ?? 0;
    
    // Инициализируем массив для эмитента если его нет
    if (!isset($instrumentsByType[$type_id][$emitent_name])) {
        $instrumentsByType[$type_id][$emitent_name] = [
            'id' => $emitent_id,
            'instruments' => []
        ];
    }
    
    // Добавляем инструмент
    $instrumentsByType[$type_id][$emitent_name]['instruments'][] = $inst;
}

// Подсчитываем количество инструментов по типам для метрик
$typesCounts = [];
foreach ($instrumentsByType as $type_id => $emitents) {
    $count = 0;
    foreach ($emitents as $emitent_data) {
        $count += count($emitent_data['instruments']);
    }
    if ($count > 0) {
        $typesCounts[$type_id] = $count;
    }
}

// Подсчитываем ОБЩЕЕ количество инструментов каждого типа в БД
$typesTotalCounts = [];
$sql_total = "
    SELECT 
        Instrument_SUPERTYPE_ID,
        COUNT(*) as total
    FROM Instrument
    WHERE Instrument_SUPERTYPE_ID IN (1, 2, 3, 4, 5, 6)
    GROUP BY Instrument_SUPERTYPE_ID
";
$result_total = $db->connection->query($sql_total);
if ($result_total && $result_total->num_rows > 0) {
    while ($row = $result_total->fetch_assoc()) {
        $typesTotalCounts[(int)$row['Instrument_SUPERTYPE_ID']] = (int)$row['total'];
    }
}

// Названия типов инструментов
$type_names = [
    1 => 'Акции',
    2 => 'Депозитарные расписки',
    3 => 'Еврооблигации',
    4 => 'Инвестиционные паи',
    5 => 'Ипотечные сертификаты',
    6 => 'Облигации'
];

// Иконки типов
$type_icons = [
    1 => '📈',
    2 => '📊',
    3 => '💶',
    4 => '📑',
    5 => '🏠',
    6 => '💸'
];

// ═══════════════════════════════════════════════════════════════════════════
// ТЕКУЩИЙ ПУТЬ ДЛЯ АНКОРНЫХ ССЫЛОК
// ═══════════════════════════════════════════════════════════════════════════
// Получаем чистый путь без query string и анкоров

if (!isset($_SERVER['REQUEST_URI']) || empty($_SERVER['REQUEST_URI'])) {
    $currentPath = '/';
} else {
    $currentPath = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
    
    if (empty($currentPath)) {
        $currentPath = '/';
    }
}

?>

<!-- ═══════════════════════════════════════════════════════════════════════ -->
<!-- НАЧАЛО КОНТЕЙНЕРА                                                      -->
<!-- ═══════════════════════════════════════════════════════════════════════ -->
<div class="container">

<!-- ═══════════════════════════════════════════════════════════════════════ -->
<!-- HERO СЕКЦИЯ                                                            -->
<!-- ═══════════════════════════════════════════════════════════════════════ -->
<section class="hero">
    <div class="hero-header">
        <div class="hero-content">
            <h1>🔍 Инструменты по которым нет данных</h1>
            <p class="hero-description">
                Технический анализ базы данных: финансовые инструменты, не имеющие торговых данных
            </p>
            <div class="hero-badges">
                <span class="badge">📊 Всего инструментов: <?php echo $total_count; ?></span>
            </div>
        </div>
    </div>
</section>

<!-- ═══════════════════════════════════════════════════════════════════════ -->
<!-- КЛИКАБЕЛЬНЫЕ МЕТРИКИ С АНКОРАМИ                                        -->
<!-- ═══════════════════════════════════════════════════════════════════════ -->

<?php if ($total_count > 0): ?>
<div class="metrics-grid">
    <?php foreach ($typesCounts as $type_id => $count): ?>
        <?php 
        $total_in_db = $typesTotalCounts[$type_id] ?? 0;
        ?>
        <a href="<?php echo esc($currentPath); ?>#section-type-<?php echo $type_id; ?>" 
           class="metric-card" 
           role="article"
           title="Перейти к разделу <?php echo esc($type_names[$type_id]); ?>">
            <div class="metric-icon"><?php echo $type_icons[$type_id]; ?></div>
            <div class="metric-label"><?php echo esc($type_names[$type_id]); ?></div>
            <div class="metric-value"><?php echo (int)$count; ?></div>
            <div class="metric-label">(из <?php echo (int)$total_in_db; ?>)</div>
        </a>
    <?php endforeach; ?>
</div>
<?php endif; ?>

<!-- ═══════════════════════════════════════════════════════════════════════ -->
<!-- РАЗДЕЛЫ ПО ТИПАМ ИНСТРУМЕНТОВ (1-6)                                    -->
<!-- ═══════════════════════════════════════════════════════════════════════ -->
<?php foreach ([1, 2, 3, 4, 5, 6] as $type_id): ?>
    <?php 
    $emitents = $instrumentsByType[$type_id] ?? [];
    
    // Пропускаем тип если нет инструментов
    if (empty($emitents)) continue;
    
    // Подсчитываем общее количество для заголовка
    $total_in_type = 0;
    foreach ($emitents as $emitent_data) {
        $total_in_type += count($emitent_data['instruments']);
    }
    ?>
    
    <section class="section" id="section-type-<?php echo $type_id; ?>">
        <h2 class="section-title">
            <span><?php echo $type_icons[$type_id]; ?></span>
            <?php echo esc($type_names[$type_id]); ?> (<?php echo $total_in_type; ?>)
        </h2>
        
        <!-- ЭМИТЕНТЫ ВНУТРИ ТИПА -->
        <?php foreach ($emitents as $emitent_name => $emitent_data): ?>
        
        <details class="details-section" open>
            <summary class="details-summary">
                <div class="summary-left">
                    <span>🏢</span>
                    <span><?php echo esc($emitent_name); ?></span>
                </div>
                <span class="summary-arrow">
                    <?php echo count($emitent_data['instruments']); ?> инстр.
                </span>
            </summary>
            
            <div class="details-content">
                
                <!-- КАРТОЧКИ ИНСТРУМЕНТОВ -->
                <div class="instruments-grid">
                    <?php foreach ($emitent_data['instruments'] as $inst): ?>
                    
                    <div class="instrument-card no-data">
                        
                        <span class="instrument-type">
                            <?php echo esc($inst['Instrument_TYPE'] ?? 'Тип не указан'); ?>
                        </span>
                        
                        <div class="instrument-code">
                            <?php 
                            $display_code = $inst['Instrument_TRADE_CODE'] ?? $inst['Instrument_ISIN'] ?? 'Код не указан';
                            echo esc($display_code);
                            ?>
                        </div>
                        
                        <div class="instrument-name">
                            <?php if (!empty($inst['Instrument_ISIN'])): ?>
                                ISIN: <?php echo esc($inst['Instrument_ISIN']); ?>
                            <?php endif; ?>
                        </div>
                        
                        <div class="instrument-description">
                            <?php if (!empty($inst['Instrument_TRADE_CODE']) && $inst['Instrument_TRADE_CODE'] !== $inst['Instrument_ISIN']): ?>
                                Код: <?php echo esc($inst['Instrument_TRADE_CODE']); ?><br>
                            <?php endif; ?>
                            
                            <?php if (!empty($inst['Instrument_REGISTRY_NUMBER'])): ?>
                                Рег. №: <?php echo esc($inst['Instrument_REGISTRY_NUMBER']); ?><br>
                            <?php endif; ?>
                            
                            <?php if (!empty($inst['Instrument_txt_short'])): ?>
                                <?php echo esc($inst['Instrument_txt_short']); ?>
                            <?php endif; ?>
                        </div>
                        
                        <span class="instrument-status status-no-data">⚠️ Нет данных</span>
                        
                    </div>
                    
                    <?php endforeach; ?>
                </div>
                
            </div>
            
        </details>
        
        <?php endforeach; ?>
        
    </section>
    
<?php endforeach; ?>

<!-- СООБЩЕНИЕ ЕСЛИ НЕТ ИНСТРУМЕНТОВ ВООБЩЕ -->
<?php if ($total_count === 0): ?>
<div class="info-notice">
    <strong>✅ Отличные новости!</strong><br>
    Все инструменты в базе данных имеют соответствующие данные в таблицах QUIK.
</div>
<?php endif; ?>

<!-- ИНФОРМАЦИОННОЕ УВЕДОМЛЕНИЕ -->
<div class="info-notice">
    <strong>ℹ️ Техническая информация:</strong><br>
    Эта страница показывает инструменты из таблицы <code>Instrument</code>, 
    для которых отсутствуют данные в таблицах <code>QUIK_Akcii</code> 
    и <code>QUIK_Obligacii</code>.<br><br>
    
    <strong>Причины отсутствия данных:</strong>
    <ul>
        <li>Инструмент снят с торгов</li>
        <li>Инструмент ещё не добавлен в QUIK</li>
        <li>Торги приостановлены</li>
        <li>Требуется обновление данных QUIK</li>
    </ul>
</div>

</div>
<!-- КОНЕЦ КОНТЕЙНЕРА -->

<?php
/**
 * ═══════════════════════════════════════════════════════════════════════════
 * КОНЕЦ menu2.php v4.0.0 EMITENT-STYLE ✅
 * ═══════════════════════════════════════════════════════════════════════════
 * 
 * Версия: 4.0.0 EMITENT-STYLE
 * Дата: 2025-10-20
 * Статус: PRODUCTION READY ✅
 * 
 * СТРУКТУРА:
 *   1. Hero (заголовок + общее количество)
 *   2. Кликабельные метрики (6 типов с анкорами)
 *   3. Раздел "Акции (45)" #section-type-1
 *      └── Эмитент 1 → Карточки
 *      └── Эмитент 2 → Карточки
 *   4. Раздел "Депозитарные расписки (12)" #section-type-2
 *      └── ...
 *   5. ... и так для всех 6 типов
 * 
 * ОСОБЕННОСТИ:
 *   ✅ Кликабельные метрики с анкорами (как в emitent.php)
 *   ✅ Smooth scroll к разделам
 *   ✅ Группировка по эмитентам внутри типа
 *   ✅ Открытые <details> по умолчанию (open)
 *   ✅ Серые карточки .instrument-card.no-data
 *   ✅ Все классы из best.css
 *   ✅ XSS защита через esc()
 * 
 * ИСПОЛЬЗУЕМЫЕ КЛАССЫ (все в best.css):
 *   - .container
 *   - .hero, .hero-header, .hero-content, .hero-description
 *   - .hero-badges, .badge
 *   - .metrics-grid, .metric-card (кликабельные)
 *   - .metric-icon, .metric-label, .metric-value
 *   - .section (с id="section-type-N")
 *   - .section-title
 *   - .details-section, .details-summary, .details-content
 *   - .summary-left, .summary-arrow
 *   - .instruments-grid
 *   - .instrument-card.no-data
 *   - .instrument-type, .instrument-code, .instrument-name
 *   - .instrument-description, .instrument-status
 *   - .status-no-data
 *   - .info-notice
 * 
 * ═══════════════════════════════════════════════════════════════════════════
 */