<?php
/**
 * Каталог эмитентов биржи
 * Версия: 3.1.0 COMPACT-GRID-REFINED
 * Дата: 2025-11-03
 * Основа: emitents-catalog.php v3.0.0 + User feedback
 * 
 * CHANGELOG:
 * 
 * v3.1.0 COMPACT-GRID-REFINED (2025-11-03): 
 * - MOVED: Metrics block (682/18) moved to bottom (after catalog, before legend)
 * - MERGED: Two alphabet navigations into one unified block
 * - NEW: .alphabet-nav-unified with two sections (.alphabet-section)
 * - REASON: User feedback - metrics should be at bottom, navigation should be unified
 * 
 * v3.0.0 COMPACT-GRID (2025-11-03):
 * - REFACTOR: Переход на Вариант 2 - компактный grid дизайн
 * - CHANGED: Grid layout → auto-fill minmax(200px, 1fr) для 5+ колонок
 * - CHANGED: Классы карточек → .emitent-card-v2, .card-header-v2 и т.д.
 * - REMOVED: Sticky позиционирование навигации (→ .alphabet-nav-static)
 * - REMOVED: Поля: руководитель, телефон, юридический адрес
 * - KEPT: ИНН, ОГРН (с temp-data), Дата рег (с temp-data)
 * - KEPT: H3 для названий эмитентов
 * - REASON: Компактность, больше эмитентов на экране, простая навигация
 * 
 * v2.0.0 CARD-GRID (2025-11-02):
 * - НОВЫЙ файл для страницы /emitents/
 * - ADD: Карточный дизайн эмитентов (вдохновлён bonds-catalog.php)
 * - ADD: Grid layout 3 колонки (.emitents-grid) → 3→2→1 адаптивность
 * - ADD: Sticky алфавитная навигация (А-Я + A-Z отдельно)
 * - ADD: Группировка по первой букве (русские А-Я, английские A-Z)
 * - ADD: Карточки с информацией (.emitent-card)
 * - ADD: Временные заглушки для ОГРН, даты рег, руководителя, телефона, адреса
 * - ADD: Иконки секторов (SECTOR_ICONS из БД)
 * - ADD: formatEmitentName() для форматирования названий (ПАО → (ПАО))
 * - ADD: Smooth scroll к якорям (#letter-А)
 * - ADD: Hero секция с описанием
 * - ADD: Metrics (682 эмитента, 18 секторов)
 * - ADD: Легенда с обозначениями
 * - PRESERVED: 100% соответствие RULES.md (UTF-8 без BOM, XSS, HTML5, A11Y)
 * - PRESERVED: Иерархия H1→H2(буква)→H3(эмитент рус) / H2→H3(буква англ)→H4(эмитент англ)
 * - FOR: best.css + best-css-addition.css v2.0.0 + bond-countdown.js v1.4.0
 * - REASON: Удобная навигация, красивый карточный дизайн, вся информация видна
 * 
 * СТРУКТУРА v3.0.0:
 * - Hero секция с описанием и иконкой 🏢
 * - 2 метрики (эмитентов + секторов)
 * - Статичная навигация РУССКИЕ буквы (А-Я) - БЕЗ sticky
 * - Статичная навигация АНГЛИЙСКИЕ буквы (A-Z) - БЕЗ sticky
 * - Буквы друг под другом (А, Б, В... Я)
 * - Эмитенты в Grid auto-fill minmax(200px, 1fr) для 5+ колонок
 * - Компактные карточки (.emitent-card-v2) с минимумом информации
 * - Секция английских эмитентов (E, F, N...)
 * - Иерархия: H1 → NAV(А-Я) → NAV(A-Z) → H2(буква рус) → H3(эмитент) → CARD
 * - Иерархия английских: H2(раздел) → H3(буква) → H4(эмитент) → CARD
 * - Легенда с обозначениями секторов
 * - Полная A11Y поддержка (aria-hidden на эмоджи)
 * - БЕЗ collapse (все эмитенты показаны сразу)
 * - БЕЗ JavaScript зависимостей (только bond-countdown.js для навигации)
 * 
 * ОСОБЕННОСТИ:
 * - Использует getAllEmitentsGroupedByLetter() из DB/emitents.php v3.0
 * - Форматирование через formatEmitentName() для русских букв
 * - Временные данные помечены классом .temp-data
 * - URL формат: /{EMITENT_URL}/
 * - CSP compatible (нет inline JS/CSS кроме smooth scroll)
 * - XSS защита через esc()
 * - HTML5 стандарт (void элементы без />)
 */

if (!function_exists('esc')) {
    die('<div class="alert alert-danger" role="alert"><strong>ОШИБКА:</strong> Функция esc() не найдена.</div>');
}

global $db;

if (!isset($db)) {
    die('<div class="alert alert-danger" role="alert"><strong>ОШИБКА:</strong> База данных не подключена.</div>');
}

// Подключаем функции для работы с эмитентами
require_once(__DIR__ . '/../../DB/emitents.php');

// Маппинг секторов к иконкам
if (!defined('SECTOR_ICONS')) {
    define('SECTOR_ICONS', [
        1  => '💻', // IT-сектор
        2  => '🌾', // Агропромышленный
        3  => '🏦', // Банковский
        4  => '🏛️', // Государственные
        5  => '🏥', // Медицина
        6  => '💳', // Финансы
        7  => '⚙️', // Машиностроение
        8  => '🔩', // Металлургия
        9  => '🏗️', // Строительство
        10 => '🛢️', // Нефтегаз
        11 => '🏭', // Промышленность
        12 => '📡', // Телеком
        13 => '🔬', // Химия
        14 => '🛒', // Торговля
        15 => '🚚', // Транспорт
        16 => '💰', // Инвестиции
        18 => '🧪', // Фармацевтика
        19 => '⚡'  // Энергетика
    ]);
}

// ============================================================================
// ПОЛУЧЕНИЕ ДАННЫХ ИЗ БД
// ============================================================================

// Получаем всех эмитентов с группировкой по буквам
$grouped_emitents = getAllEmitentsGroupedByLetter();

// Разделение на русские (А-Я) и английские (A-Z)
$russian_letters = [];
$english_letters = [];

foreach ($grouped_emitents as $letter => $emitents) {
    if (preg_match('/[А-ЯЁ]/u', $letter)) {
        $russian_letters[$letter] = $emitents;
    } else {
        $english_letters[$letter] = $emitents;
    }
}

// Подсчёт общего количества
$total_emitents = 0;
foreach ($grouped_emitents as $emitents) {
    $total_emitents += count($emitents);
}

// Подсчёт секторов
$total_sectors = count(SECTOR_ICONS);

// Функция pluralForm() уже существует в DB/emitents.php - не дублируем!

?>

<div class="container">

<!-- EMITENTS CATALOG PAGE WRAPPER - для изоляции CSS -->
<div class="emitents-catalog-page">

<!-- HERO СЕКЦИЯ -->
<section class="hero">
    <div class="hero-header">
        <span class="sector-icon-large" aria-hidden="true">🏢</span>
        <div class="hero-content-sector">
            <h1>Каталог эмитентов Фондового рынка Российской Федерации</h1>
            <p class="hero-description">
                Полный список из <?php echo esc($total_emitents); ?> эмитентов ценных бумаг, торгующихся на фондовой бирже. 
                Эмитенты структурированы по алфавиту с удобной навигацией для быстрого поиска 
                компаний из <?php echo esc($total_sectors); ?> секторов российской экономики.
            </p>
        </div>
    </div>
</section>

<!-- FLEXBOX WRAPPER ДЛЯ ИЗМЕНЕНИЯ ПОРЯДКА НА MOBILE -->
<div class="page-content-wrapper">

    <!-- КАТАЛОГ WRAPPER -->
    <div class="catalog-wrapper">

        <?php if (empty($grouped_emitents)): ?>
        <div class="alert alert-info" role="alert">
            <strong>Нет данных</strong><br>
            В базе данных не найдено эмитентов для отображения.
        </div>
        <?php else: ?>

        <!-- UNIFIED ALPHABET NAVIGATION (Russian А-Я + English A-Z) -->
        <nav class="alphabet-nav-unified" aria-label="Алфавитная навигация">
            
            <!-- Russian letters section -->
            <div class="alphabet-section">
                <div class="alphabet-nav-title">А–Я:</div>
                <div class="alphabet-nav-letters">
                <?php foreach (array_keys($russian_letters) as $letter): ?>
                    <a href="/emitents/#letter-<?php echo esc($letter); ?>" 
                       class="letter-link" 
                       data-letter="<?php echo esc($letter); ?>"
                       title="Перейти к букве <?php echo esc($letter); ?>">
                        <?php echo esc($letter); ?>
                    </a>
                <?php endforeach; ?>
                </div>
            </div>
            
            <!-- English letters section (if exists) -->
            <?php if (!empty($english_letters)): ?>
            <div class="alphabet-section alphabet-section-english">
                <div class="alphabet-nav-title">Названия на английском:</div>
                <div class="alphabet-nav-letters">
                <?php foreach (array_keys($english_letters) as $letter): ?>
                    <a href="/emitents/#letter-<?php echo esc($letter); ?>" 
                       class="letter-link" 
                       data-letter="<?php echo esc($letter); ?>"
                       title="Перейти к букве <?php echo esc($letter); ?>">
                        <?php echo esc($letter); ?>
                    </a>
                <?php endforeach; ?>
                </div>
            </div>
            <?php endif; ?>
            
        </nav>

        <!-- РУССКИЕ БУКВЫ (А-Я) -->
        <div class="emitents-catalog-container">
            
            <?php foreach ($russian_letters as $letter => $emitents): ?>
            
            <section class="letter-section" id="letter-<?php echo esc($letter); ?>" data-letter="<?php echo esc($letter); ?>">
                <h2 class="letter-title"><?php echo esc($letter); ?></h2>
                
                <!-- ЭМИТЕНТЫ В COMPACT GRID (5+ колонок auto-fill) -->
                <div class="grid-5-columns">
                    
                    <?php foreach ($emitents as $emitent): ?>
                    
                    <!-- КАРТОЧКА ЭМИТЕНТА -->
                    <div class="emitent-card-v2">
                        
                        <!-- ЗАГОЛОВОК -->
                        <div class="card-header-v2">
                            <span class="sector-icon-v2" 
                                  aria-hidden="true" 
                                  title="<?php echo esc($emitent->SECTOR_ECONOMIKI); ?>">
                                <?php echo SECTOR_ICONS[$emitent->ID_SECTOR_ECONOMIKI] ?? '🏢'; ?>
                            </span>
                            <h3 class="card-title-v2">
                                <?php echo esc(formatEmitentName($emitent->EMITENT_SHORT_NAME)); ?>
                            </h3>
                        </div>
                        
                        <!-- ТЕЛО -->
                        <div class="card-body-v2">
                            
                            <!-- ИНН -->
                            <div class="info-row-v2">
                                <span class="info-label-v2">ИНН:</span>
                                <span class="info-value-v2"><?php echo esc($emitent->INN); ?></span>
                            </div>
                            
                            <!-- ОГРН (временная заглушка) -->
                            <div class="info-row-v2">
                                <span class="info-label-v2">ОГРН:</span>
                                <span class="info-value-v2 temp-data">не указан</span>
                            </div>
                            
                            <!-- Дата регистрации (временная заглушка) -->
                            <div class="info-row-v2">
                                <span class="info-label-v2">Дата рег:</span>
                                <span class="info-value-v2 temp-data">не указана</span>
                            </div>
                            
                        </div>
                        
                        <!-- ПОДВАЛ -->
                        <div class="card-footer-v2">
                            <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '/') . esc($emitent->EMITENT_URL); ?>/" 
                               class="emitent-link-v2"
                               title="<?php echo esc($emitent->EMITENT_ANKOR); ?>">
                                О компании →
                            </a>
                        </div>
                        
                    </div>
                    <!-- КОНЕЦ КАРТОЧКИ -->
                    
                    <?php endforeach; ?>
                    
                </div>
                <!-- КОНЕЦ GRID -->
                
            </section>
            
            <?php endforeach; ?>
            
        </div>
        <!-- КОНЕЦ РУССКИЕ БУКВЫ -->

        <!-- АНГЛИЙСКИЕ БУКВЫ (A-Z) -->
        <?php if (!empty($english_letters)): ?>
        
        <section class="english-section">
            <h2 class="english-section-title">Эмитенты на английском языке</h2>
            
            <?php foreach ($english_letters as $letter => $emitents): ?>
            
            <section class="letter-section" id="letter-<?php echo esc($letter); ?>" data-letter="<?php echo esc($letter); ?>">
                <h3 class="letter-title letter-title-english"><?php echo esc($letter); ?></h3>
                
                <!-- ЭМИТЕНТЫ В COMPACT GRID (5+ колонок auto-fill) -->
                <div class="grid-5-columns">
                    
                    <?php foreach ($emitents as $emitent): ?>
                    
                    <!-- КАРТОЧКА ЭМИТЕНТА -->
                    <div class="emitent-card-v2">
                        
                        <!-- ЗАГОЛОВОК -->
                        <div class="card-header-v2">
                            <span class="sector-icon-v2" 
                                  aria-hidden="true" 
                                  title="<?php echo esc($emitent->SECTOR_ECONOMIKI); ?>">
                                <?php echo SECTOR_ICONS[$emitent->ID_SECTOR_ECONOMIKI] ?? '🏢'; ?>
                            </span>
                            <h4 class="card-title-v2">
                                <?php echo esc($emitent->EMITENT_SHORT_NAME); ?>
                            </h4>
                        </div>
                        
                        <!-- ТЕЛО -->
                        <div class="card-body-v2">
                            
                            <!-- ИНН -->
                            <div class="info-row-v2">
                                <span class="info-label-v2">ИНН:</span>
                                <span class="info-value-v2"><?php echo esc($emitent->INN); ?></span>
                            </div>
                            
                            <!-- ОГРН (временная заглушка) -->
                            <div class="info-row-v2">
                                <span class="info-label-v2">ОГРН:</span>
                                <span class="info-value-v2 temp-data">не указан</span>
                            </div>
                            
                            <!-- Дата регистрации (временная заглушка) -->
                            <div class="info-row-v2">
                                <span class="info-label-v2">Дата рег:</span>
                                <span class="info-value-v2 temp-data">не указана</span>
                            </div>
                            
                        </div>
                        
                        <!-- ПОДВАЛ -->
                        <div class="card-footer-v2">
                            <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '/') . esc($emitent->EMITENT_URL); ?>/" 
                               class="emitent-link-v2"
                               title="<?php echo esc($emitent->EMITENT_ANKOR); ?>">
                                О компании →
                            </a>
                        </div>
                        
                    </div>
                    <!-- КОНЕЦ КАРТОЧКИ -->
                    
                    <?php endforeach; ?>
                    
                </div>
                <!-- КОНЕЦ GRID -->
                
            </section>
            
            <?php endforeach; ?>
            
        </section>
        
        <?php endif; ?>
        <!-- КОНЕЦ АНГЛИЙСКИЕ БУКВЫ -->

        <?php endif; ?>

    </div>
    <!-- КОНЕЦ КАТАЛОГ WRAPPER -->

    <!-- МЕТРИКИ WRAPPER (moved down from top) -->
    <div class="metrics-wrapper">
        <!-- КОМПАКТНАЯ СТАТИСТИКА -->
        <div class="metrics-grid metrics-grid-compact">
            
            <!-- ВСЕГО ЭМИТЕНТОВ -->
            <div class="metric-card metric-card-compact" role="article" aria-describedby="metric-emitents-desc">
                <div class="metric-icon metric-icon-compact" aria-hidden="true">🏢</div>
                <div class="metric-label">Эмитентов</div>
                <div class="metric-value"><?php echo esc($total_emitents); ?></div>
                <span id="metric-emitents-desc" class="sr-only">
                    Всего эмитентов в каталоге: <?php echo esc($total_emitents); ?>
                </span>
            </div>
            
            <!-- СЕКТОРОВ -->
            <div class="metric-card metric-card-compact" role="article" aria-describedby="metric-sectors-desc">
                <div class="metric-icon metric-icon-compact" aria-hidden="true">🗂️</div>
                <div class="metric-label">Секторов</div>
                <div class="metric-value"><?php echo esc($total_sectors); ?></div>
                <span id="metric-sectors-desc" class="sr-only">
                    Количество секторов экономики: <?php echo esc($total_sectors); ?>
                </span>
            </div>
            
        </div>
    </div>
    <!-- КОНЕЦ МЕТРИКИ WRAPPER -->

    <!-- ЛЕГЕНДА WRAPPER -->
    <div class="legend-wrapper">

        <!-- ОБОЗНАЧЕНИЯ -->
        <div class="legend-block">
            <h3 class="legend-title">
                <span aria-hidden="true">🔍</span>
                Обозначения секторов
            </h3>
            <div class="legend-content">
                <div class="legend-item">
                    <span class="legend-icon" aria-hidden="true">💻</span>
                    <strong>IT-сектор</strong>
                </div>
                <div class="legend-item">
                    <span class="legend-icon" aria-hidden="true">🌾</span>
                    <strong>Агропромышленный</strong>
                </div>
                <div class="legend-item">
                    <span class="legend-icon" aria-hidden="true">🏦</span>
                    <strong>Банковский</strong>
                </div>
                <div class="legend-item">
                    <span class="legend-icon" aria-hidden="true">🏛️</span>
                    <strong>Государственные</strong>
                </div>
                <div class="legend-item">
                    <span class="legend-icon" aria-hidden="true">🏥</span>
                    <strong>Медицина</strong>
                </div>
                <div class="legend-item">
                    <span class="legend-icon" aria-hidden="true">💳</span>
                    <strong>Финансы</strong>
                </div>
                <div class="legend-item">
                    <span class="legend-icon" aria-hidden="true">⚙️</span>
                    <strong>Машиностроение</strong>
                </div>
                <div class="legend-item">
                    <span class="legend-icon" aria-hidden="true">🔩</span>
                    <strong>Металлургия</strong>
                </div>
                <div class="legend-item">
                    <span class="legend-icon" aria-hidden="true">🏗️</span>
                    <strong>Строительство</strong>
                </div>
                <div class="legend-item">
                    <span class="legend-icon" aria-hidden="true">🛢️</span>
                    <strong>Нефтегаз</strong>
                </div>
                <div class="legend-item">
                    <span class="legend-icon" aria-hidden="true">🏭</span>
                    <strong>Промышленность</strong>
                </div>
                <div class="legend-item">
                    <span class="legend-icon" aria-hidden="true">📡</span>
                    <strong>Телеком</strong>
                </div>
                <div class="legend-item">
                    <span class="legend-icon" aria-hidden="true">🔬</span>
                    <strong>Химия</strong>
                </div>
                <div class="legend-item">
                    <span class="legend-icon" aria-hidden="true">🛒</span>
                    <strong>Торговля</strong>
                </div>
                <div class="legend-item">
                    <span class="legend-icon" aria-hidden="true">🚚</span>
                    <strong>Транспорт</strong>
                </div>
                <div class="legend-item">
                    <span class="legend-icon" aria-hidden="true">💰</span>
                    <strong>Инвестиции</strong>
                </div>
                <div class="legend-item">
                    <span class="legend-icon" aria-hidden="true">🧪</span>
                    <strong>Фармацевтика</strong>
                </div>
                <div class="legend-item">
                    <span class="legend-icon" aria-hidden="true">⚡</span>
                    <strong>Энергетика</strong>
                </div>
            </div>
        </div>

        <div class="info-notice">
            <strong>Источник данных:</strong> Справочная информация из базы данных DeepMax.ru.<br>
            Данные обновляются периодически.<br><br>
            <strong>Временные данные:</strong> Поля ОГРН и дата регистрации будут заполнены 
            при расширении базы данных.
        </div>

    </div>
    <!-- КОНЕЦ ЛЕГЕНДА WRAPPER -->

</div>
<!-- КОНЕЦ PAGE-CONTENT-WRAPPER -->

</div>
<!-- END EMITENTS CATALOG PAGE WRAPPER -->

</div>