<?

require_once('config.php');
require_once('util.php');

try {

   $input = file_get_contents('php://input');

   //input_log($input);

   if($input !== false && strlen($input) > 0){

      // JSON
      if(strpos($input, '{') === 0){
         require_once('DB/db.php');
         $db = new Database();
         require_once('DB/trade.php');

         $json = json_decode($input, true);

         if($json['Data'] != null
         && $json['Time'] != null
         && $json['Operation'] != null
         && $json['Tiket'] != null
         && $json['Price'] != null
         && $json['Lots'] != null
         && $json['Sum'] != null
         && $json['AM'] != null
         && $json['Y'] != null){

            $trade = new Trade();
            $trade->Data = $json['Data'];
            $trade->Time = $json['Time'];
            $trade->Operation = $json['Operation'];
            $trade->Tiket = $json['Tiket'];
            $trade->Price = $json['Price'];
            $trade->Lots = $json['Lots'];
            $trade->Sum = $json['Sum'];
            $trade->AM = $json['AM'];
            $trade->Y = $json['Y'];
            $trade->Profit = 0;

            if($trade->Operation == 'Sell' && $trade->AM == 'A'){
               $trade->Profit = abs(round($trade->Sum * $trade->Y / 100, 2));
            }

            addTrade($trade);
         }
      }
   }
} catch (Throwable $e) {

   my_error_log($e->getMessage() . ': ' . $e->getFile() . ' #' . $e->getLine());

}