<?php
// Подключает файл конфигурации
require_once('config.php');
// Подключает файл инструментария (вспомогательные функции)
require_once('util.php');

// Подключает функционал кеширования (ДО Debug System!)
require_once('cache.php');

// === DEBUG SYSTEM v4.4.0 HOOKS - START ===
// Подключается ТОЛЬКО если файл существует (для совместимости и безопасности)
if (file_exists(__DIR__ . '/classes/Debug/DeepMaxDebug.php')) {
    require_once(__DIR__ . '/classes/Debug/DeepMaxDebug.php');
    DeepMaxDebug::init();
    
    // v2.5.2 FINAL: Регистрируем хук для вставки Debug панели через Cache
    // FIX #5: Используем strripos() для поиска ПОСЛЕДНЕГО </body>
    // FIX #6: Проверяем что панель ещё не добавлена
    if (DeepMaxDebug::isEnabled()) {
        Cache::addBeforeOutputHook(function($content) {
            // Получаем HTML панели из DeepMaxDebug
            $panel = DeepMaxDebug::getPanelHTML();
            
            // Если панель пустая - возвращаем контент без изменений
            if (empty($panel)) {
                return $content;
            }
            
            // FIX #6: Проверка что панель ещё не добавлена
            if (!empty($content) && is_string($content) && stripos($content, 'deepmax-debug-panel') !== false) {
                return $content;
            }
            
            // FIX #5: Ищем ПОСЛЕДНЕЕ вхождение </body> (strripos вместо stripos)
            // Это предотвращает вставку панели внутри <script> если там есть "</body>"
            $bodyPos = strripos($content, '</body>');
            
            if ($bodyPos !== false) {
                // Вставляем панель перед последним </body>
                return substr_replace($content, $panel, $bodyPos, 0);
            } else {
                // Если </body> не найден - добавляем в конец
                return $content . $panel;
            }
        });
    }
}
// === DEBUG SYSTEM v4.4.0 HOOKS - END ===

try {

   // Определяет запрашиваемую страницу
   $url_parts = get_page_url();
   // v2.5.6 PAGE_URL_FIX: Определяем $page_url ПЕРЕД использованием в my_log()
   $page_url = trim($_SERVER['REQUEST_URI'] ?? '/', '/');
   $page_key = '';
   for($i=1;$i<count($url_parts);$i++){
      if ($url_parts[$i] != '') $page_key .= '_' . $url_parts[$i];
   }
   
   my_log($page_url . ' ' . $_SERVER['REQUEST_METHOD']);

   // POST запрос из Quik
   if($_SERVER['REQUEST_METHOD'] === 'POST' && $url_parts[1] == 'quik-connector'){
      if($url_parts[2] == 'set-trade.php'){
         require_once('quik-connector/set-trade.php');
      }elseif($url_parts[2] == 'set-money.php'){
         require_once('quik-connector/set-money.php');
      }elseif($url_parts[2] == 'set-settings.php'){
         require_once('quik-connector/set-settings.php');
      }elseif($url_parts[2] == 'set-securities.php'){
         require_once('quik-connector/set-securities.php');
      }elseif($url_parts[2] == 'set-securities-current-params.php'){
         require_once('quik-connector/set-securities-current-params.php');
      }
   // GET запрос из браузера
   }else{

      // v2.5.5 MOBILE_REMOVED: Используем Cache::output() с правильным scope
      Cache::output($page_key, function() use ($url_parts) {
         
         // v2.5.5 MOBILE_REMOVED: Объявляем переменные глобальными
         // КРИТИЧНО: $db, $breadcrumb, $page_data, $page_type, $page_url используются в include файлах
         // Они ожидают эти переменные в глобальной области видимости
         global $db, $breadcrumb, $page_data, $page_type, $page_url, $title, $og_title, $og_description;
         global $og_image, $og_image_alt, $og_url, $description, $keywords;
         global $is_mobile;
         global $emitent;
         
         // Подключается к базе данных
         require_once('DB/db.php');
         $db = new Database();
         
         // Подключаем хлебные крошки
         require_once('classes/BreadcrumbBuilder.php');
         $breadcrumb = new BreadcrumbBuilder($db);
         $currentUrl = 'https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
         $breadcrumb->build($currentUrl);
         
         // Подгружает функционал получения данных для страницы из БД
         require_once('DB/page.php');      

         // Устанавливает из БД значения необходимым для страницы переменным и возвращает метаданные страницы
         $page_data = setPageVariablesAndGetPageTypeAndMeta($url_parts);
         
         // v2.5.5 MOBILE_REMOVED: Определяем переменную $page_type для использования в footer.php
         // Теперь условия типа: if ($page_type === 'bond') будут работать
         $page_type = $page_data[0];

         // v2.5.5 MOBILE_REMOVED: Отключено определение мобильных устройств
         // ПРИЧИНА: Мобильные версии страниц не используются (нет папки site/content/mob/)
         // РЕШЕНИЕ: Полагаемся на адаптивный CSS в best.css (современный подход)
         // Все пользователи видят desktop версию, которая адаптируется через media queries
         $is_mobile = false;

         // Подгружает элемент head (метаданные, стили, шрифты, библиотеки)
         include 'site/head.php';
         // Подгружает шапку сайта с меню
         include 'site/header.php';
         // Подгружает основной контент страницы в зависимости от выбранного адреса
         require_once 'site/content.php';
         // Подгружает подвал сайта
         include 'site/footer.php';
         
      }); // Cache::output() автоматически:
          // 1. Применит все хуки (Debug панель)
          // 2. Сохранит в кэш (если нужно)
          // 3. Выведет результат
   }

} catch (\Throwable $e) {

   @my_error_log($e->getMessage() . ': ' . $e->getFile() . ' #' . $e->getLine());
   
   // v2.5.5 MOBILE_REMOVED: Безопасная очистка буферов при исключении
   if (function_exists('ob_get_level') && function_exists('ob_end_clean')) {
       $maxIterations = 100;
       $iteration = 0;
       $prevLevel = -1;
       
       while ($iteration < $maxIterations) {
           $currentLevel = @ob_get_level();
           
           if ($currentLevel === 0 || $currentLevel === false) {
               break;
           }
           
           if ($currentLevel === $prevLevel) {
               @error_log('[StockV6] [INDEX.PHP v2.5.6] WARNING: Buffer level stuck at ' . $currentLevel);
               break;
           }
           
           $prevLevel = $currentLevel;
           @ob_end_clean();
           $iteration++;
       }
       
       if ($iteration >= $maxIterations) {
           @error_log('[StockV6] [INDEX.PHP v2.5.6] WARNING: Reached max iterations (' . $maxIterations . ') cleaning buffers');
       }
   }
   
   // Выводим минимальное сообщение об ошибке
   if (!headers_sent()) {
       @http_response_code(500);
       @header('Content-Type: text/html; charset=UTF-8');
       
       if (function_exists('ob_get_level') && @ob_get_level() > 0) {
           @ob_clean();
       }
       
       echo '<!DOCTYPE html><html lang="ru"><head><meta charset="UTF-8"><title>Ошибка</title></head><body>';
       echo '<h1>Произошла ошибка</h1>';
       echo '<p>Пожалуйста, попробуйте позже или обратитесь к администратору.</p>';
       echo '</body></html>';
   }
   
   exit(1);
}

/**
 * index.php v2.5.6 PAGE_URL_FIX
 * Дата: 2025-10-20
 * Статус: PRODUCTION READY
 */