<?php
/**
 * Определяет является ли текущий визитор поисковым ботом
 * @return bool
 */
function isSearchBot() {
    $userAgent = strtolower($_SERVER['HTTP_USER_AGENT'] ?? '');
    
    // Проверка на пустой User-Agent
    if (empty($userAgent)) {
        return false;
    }
    
    // Полный список поисковых ботов
    $bots = [
        // Google
        'googlebot',
        'google-inspectiontool',
        'adsbot-google',
        
        // Яндекс
        'yandexbot',
        'yandexmobilebot',
        'yandexaccessibilitybot',
        'yandexadnet',
        'yandexdirect',
        
        // Другие поисковики
        'bingbot',
        'mail.ru_bot',
        'go.mail.ru',
        'rambler',
        'sputnikbot',
        'baiduspider',
        'duckduckbot',
        'slurp',
        'msnbot',
        
        // Соцсети
        'facebookexternalhit',
        'twitterbot',
        'telegrambot',
        'vkshare',
        'odnoklassniki',
        
        // Другие
        'applebot',
        'linkedinbot',
        
        // SEO инструменты
        'ahrefsbot',
        'semrushbot',
        'dotbot',
        'mj12bot',
        'screaming frog',
        
        // Другие краулеры
        'petalbot',
        'seznambot'
    ];
    
    foreach ($bots as $bot) {
        if (strpos($userAgent, $bot) !== false) {
            return true;
        }
    }
    
    return false;
}
?>