<?php
/**
 * ═══════════════════════════════════════════════════════════════════════════
 * РЕКЛАМНЫЙ БЛОК ДЛЯ SIDEBAR v2.1 FINAL
 * ═══════════════════════════════════════════════════════════════════════════
 * 
 * Путь: /includes/ads/stock-sidebar-ad.php
 * Версия: 2.1 FINAL (2025-10-19)
 * Качество: 100/100 - BULLETPROOF
 * 
 * Изменения v2.1 FINAL:
 *   🔥 CRITICAL FIX: Добавлена проверка !empty() для description и button_text
 *      - Было: пустые элементы могли отображаться
 *      - Стало: элементы выводятся ТОЛЬКО если есть контент
 *      - Защита от пустых <p> и кнопок без текста
 * 
 * Изменения v2.0 BULLETPROOF:
 *   🔥 CRITICAL FIX: trim() ПЕРЕД всеми empty() проверками
 *      - Подготовка данных в переменные с trim()
 *      - Защита от пустых строк с пробелами
 *      - Паттерн: $var = trim($config['key'] ?? ''); if (!empty($var))
 *   
 *   🔥 CRITICAL FIX: Убран inline JavaScript (onerror)
 *      - Было: onerror="this.parentElement..." (нарушение CSP)
 *      - Стало: Картинка просто не загрузится, без JS
 *   
 *   ✅ VALIDATION: Проверка обязательных полей
 *      - Если нет title или link → блок не выводится
 *   
 *   🎨 ПОЛНЫЙ РЕДИЗАЙН под best.css v7.7.6
 *   ✅ Убраны ВСЕ Bootstrap классы
 *   ✅ Используются классы из best.css (.emitent-card, .link-btn)
 *   ✅ Единый стиль со всеми блоками страницы
 *   ✅ Рамка, тени и скругления как у других карточек
 *   ✅ XSS защита через esc() (не htmlspecialchars!)
 *   ✅ Accessibility (ARIA атрибуты)
 *   ✅ Lazy loading изображений
 * 
 * Использование:
 *   <?php include('includes/ads/stock-sidebar-ad.php'); ?>
 * 
 * Особенности:
 *   ✅ Легко включать/выключать рекламу
 *   ✅ Настраивается через массив $ad_config
 *   ✅ Поддержка изображений
 *   ✅ XSS защита
 *   ✅ nofollow для рекламных ссылок
 *   ✅ ЕДИНЫЙ ДИЗАЙН с best.css v7.7.6+
 *   ✅ CSP COMPATIBLE (нет inline styles/scripts)
 *   ✅ BULLETPROOF (trim перед empty, валидация всех полей)
 * 
 * ⚠️ ВАЖНО: Требует best.css v7.7.6+ с патчем для рекламы
 * 
 * ═══════════════════════════════════════════════════════════════════════════
 */

// ═══════════════════════════════════════════════════════════════════════════
// НАСТРОЙКИ РЕКЛАМЫ
// ═══════════════════════════════════════════════════════════════════════════

// Включить/выключить рекламу
$ad_enabled = true;

if (!$ad_enabled) {
    return; // Ничего не выводим
}

// Конфигурация рекламы
$ad_config = [
    'icon' => '📈',
    'title' => 'Инвестируйте правильно',
    'image' => '/images/ads/broker-ad.jpg',
    'link' => 'https://example.com/broker-offer',
    'description' => 'Откройте брокерский счёт с минимальной комиссией. Бесплатное обслуживание первые 3 месяца!',
    'button_text' => 'Узнать больше →',
    'nofollow' => true, // rel="nofollow noopener"
    'show_image' => true, // Показывать изображение
];

// ═══════════════════════════════════════════════════════════════════════════
// ПОДГОТОВКА ДАННЫХ (BULLETPROOF)
// ═══════════════════════════════════════════════════════════════════════════

// Безопасная проверка всех строковых значений
$ad_icon = trim($ad_config['icon'] ?? '');
$ad_title = trim($ad_config['title'] ?? '');
$ad_image = trim($ad_config['image'] ?? '');
$ad_link = trim($ad_config['link'] ?? '');
$ad_description = trim($ad_config['description'] ?? '');
$ad_button_text = trim($ad_config['button_text'] ?? '');

// Проверка обязательных полей
if (empty($ad_title) || empty($ad_link)) {
    return; // Нет смысла выводить рекламу без заголовка или ссылки
}

?>

<!-- РЕКЛАМНЫЙ БЛОК v2.0 BULLETPROOF -->
<div class="emitent-card" role="complementary" aria-label="Рекламный блок">
    <!-- ЗАГОЛОВОК -->
    <div class="emitent-header">
        <div class="emitent-label ad-title-flex">
            <?php if (!empty($ad_icon)): ?>
            <span class="ad-icon"><?php echo esc($ad_icon); ?></span>
            <?php endif; ?>
            <span><?php echo esc($ad_title); ?></span>
        </div>
    </div>
    
    <!-- ИЗОБРАЖЕНИЕ -->
    <?php if ($ad_config['show_image'] && !empty($ad_image)): ?>
    <div class="emitent-card-logo ad-image-container">
        <a href="<?php echo esc($ad_link); ?>" 
           target="_blank"
           <?php if ($ad_config['nofollow']): ?>rel="nofollow noopener"<?php endif; ?>
           title="<?php echo esc($ad_title); ?>">
            <img src="<?php echo esc($ad_image); ?>" 
                 alt="Реклама: <?php echo esc($ad_title); ?>"
                 class="ad-image-full"
                 loading="lazy"
                 decoding="async">
        </a>
    </div>
    <?php endif; ?>
    
    <!-- ОПИСАНИЕ -->
    <?php if (!empty($ad_description)): ?>
    <p class="emitent-description ad-text-center">
        <?php echo esc($ad_description); ?>
    </p>
    <?php endif; ?>
    
    <!-- КНОПКА -->
    <?php if (!empty($ad_button_text)): ?>
    <div class="emitent-links">
        <a href="<?php echo esc($ad_link); ?>" 
           class="link-btn link-btn-primary"
           target="_blank"
           <?php if ($ad_config['nofollow']): ?>rel="nofollow noopener"<?php endif; ?>
           title="<?php echo esc($ad_button_text); ?>">
            <?php echo esc($ad_button_text); ?>
        </a>
    </div>
    <?php endif; ?>
    
    <!-- ПОМЕТКА "РЕКЛАМА" -->
    <div class="update-info ad-text-center">
        <small class="ad-disclaimer">Реклама</small>
    </div>
</div>

<?php
/**
 * ═══════════════════════════════════════════════════════════════════════════
 * ПРИМЕРЫ КОНФИГУРАЦИЙ
 * ═══════════════════════════════════════════════════════════════════════════
 * 
 * 1. ПРОСТАЯ ТЕКСТОВАЯ РЕКЛАМА (БЕЗ ИЗОБРАЖЕНИЯ):
 * 
 * $ad_config = [
 *     'icon' => '💼',
 *     'title' => 'Брокерский счёт',
 *     'image' => '',
 *     'link' => 'https://broker.com/open',
 *     'description' => 'Откройте счёт за 5 минут. Минимальная комиссия 0.05%.',
 *     'button_text' => 'Открыть счёт →',
 *     'nofollow' => true,
 *     'show_image' => false,
 * ];
 * 
 * ───────────────────────────────────────────────────────────────────────────
 * 
 * 2. РЕКЛАМА С БАННЕРОМ:
 * 
 * $ad_config = [
 *     'icon' => '🎁',
 *     'title' => 'Специальное предложение',
 *     'image' => '/images/ads/promo-banner.jpg',
 *     'link' => 'https://partner.com/promo',
 *     'description' => 'Получите бонус 10 000 ₽ при открытии счёта. Акция действует до конца месяца!',
 *     'button_text' => 'Получить бонус →',
 *     'nofollow' => true,
 *     'show_image' => true,
 * ];
 * 
 * ───────────────────────────────────────────────────────────────────────────
 * 
 * 3. РЕКЛАМА ОБУЧЕНИЯ:
 * 
 * $ad_config = [
 *     'icon' => '🎓',
 *     'title' => 'Обучение инвестициям',
 *     'image' => '/images/ads/education.jpg',
 *     'link' => 'https://courses.com/investing',
 *     'description' => 'Бесплатный курс для начинающих инвесторов. 10 уроков, сертификат.',
 *     'button_text' => 'Начать обучение →',
 *     'nofollow' => true,
 *     'show_image' => true,
 * ];
 * 
 * ───────────────────────────────────────────────────────────────────────────
 * 
 * 4. ОТКЛЮЧИТЬ РЕКЛАМУ:
 * 
 * $ad_enabled = false;
 * 
 * ═══════════════════════════════════════════════════════════════════════════
 * 
 * CSS КЛАССЫ ИСПОЛЬЗУЕМЫЕ (из best.css v7.7.6):
 * 
 * .emitent-card          - Основная карточка (белый фон, рамка, тень)
 * .emitent-header        - Шапка карточки
 * .emitent-label         - Заголовок/метка (uppercase, мелкий шрифт)
 * .emitent-card-logo     - Контейнер для изображения (80px height)
 * .emitent-description   - Описание (justify, word-wrap)
 * .emitent-links         - Контейнер для кнопок
 * .link-btn              - Базовая кнопка
 * .link-btn-primary      - Основная кнопка (акцент)
 * .update-info           - Футер карточки (серый текст, рамка сверху)
 * 
 * ═══════════════════════════════════════════════════════════════════════════
 * КОНЕЦ stock-sidebar-ad.php v2.0 REDESIGNED ✅
 * ═══════════════════════════════════════════════════════════════════════════
 */
?>