
#!/bin/bash

echo " ПРОВЕРКА CSS КЛАССОВ"

BASE_DIR="/var/www/www-root/data/www/deepmax.ru"

EMITENT_PHP="$BASE_DIR/site/content/emitent.php"



echo " Проверяю файл: $EMITENT_PHP"

if [ ! -f "$EMITENT_PHP" ]; then

    echo "❌ Файл НЕ НАЙДЕН!"

    exit 1

fi

echo "✅ Файл найден"

echo ""



classes=$(grep -o 'class="[^"]*"' "$EMITENT_PHP" | sed 's/class="//g; s/"//g' | tr ' ' '\n' | sort -u | grep -v '^$')

critical=$(cat "$BASE_DIR/css-modules/dist/critical.min.css")

core=$(cat "$BASE_DIR/css-modules/dist/core.min.css")

emitent=$(cat "$BASE_DIR/css-modules/dist/pages/emitent.min.css")



total=0

found=0



for class in $classes; do

    total=$((total + 1))

    if echo "$critical$core$emitent" | grep -q "\.$class"; then

        echo "✅ .$class"

        found=$((found + 1))

    else

        echo " .$class - НЕ НАЙДЕН!"

    fi

done



echo ""

echo "═══════════════════════════════════"

echo "Всего классов:    $total"

echo "✅ Найдено:       $found"

echo " Отсутствует:   $((total - found))"

echo ""



if [ $found -eq $total ]; then

    echo " ВСЕ КЛАССЫ НАЙДЕНЫ!"

else

    echo "⚠️ Есть отсутствующие классы!"

fi

