#!/bin/bash

echo "🔍 ПРОВЕРКА ВСЕХ CSS КЛАССОВ ИЗ EMITENT.PHP"
echo "═══════════════════════════════════════════════════════════"
echo ""

# ПУТИ (скрипт в css-modules/)
BASE_DIR="/var/www/www-root/data/www/deepmax.ru"
EMITENT_PHP="$BASE_DIR/site/emitent.php"
CRITICAL_CSS="$BASE_DIR/css-modules/dist/critical.min.css"
CORE_CSS="$BASE_DIR/css-modules/dist/core.min.css"
EMITENT_CSS="$BASE_DIR/css-modules/dist/pages/emitent.min.css"

# Проверка существования файлов
echo "📂 Проверка файлов:"
if [ ! -f "$EMITENT_PHP" ]; then
    echo "❌ emitent.php НЕ НАЙДЕН: $EMITENT_PHP"
    exit 1
else
    echo "✅ emitent.php найден"
fi

if [ ! -f "$CRITICAL_CSS" ]; then
    echo "❌ critical.min.css НЕ НАЙДЕН: $CRITICAL_CSS"
    echo "   Запусти: ./build-css.sh"
    exit 1
else
    size=$(wc -c < "$CRITICAL_CSS")
    echo "✅ critical.min.css найден ($size bytes)"
    if [ "$size" -lt 1000 ]; then
        echo "   ⚠️  ВНИМАНИЕ: Файл слишком маленький! Возможно пустой?"
    fi
fi

if [ ! -f "$CORE_CSS" ]; then
    echo "❌ core.min.css НЕ НАЙДЕН: $CORE_CSS"
    echo "   Запусти: ./build-css.sh"
    exit 1
else
    size=$(wc -c < "$CORE_CSS")
    echo "✅ core.min.css найден ($size bytes)"
    if [ "$size" -lt 1000 ]; then
        echo "   ⚠️  ВНИМАНИЕ: Файл слишком маленький! Возможно пустой?"
    fi
fi

if [ ! -f "$EMITENT_CSS" ]; then
    echo "❌ emitent.min.css НЕ НАЙДЕН: $EMITENT_CSS"
    echo "   Запусти: ./build-css.sh"
    exit 1
else
    size=$(wc -c < "$EMITENT_CSS")
    echo "✅ emitent.min.css найден ($size bytes)"
    if [ "$size" -lt 100 ]; then
        echo "   ⚠️  ВНИМАНИЕ: Файл слишком маленький! Возможно пустой?"
    fi
fi

echo ""
echo "═══════════════════════════════════════════════════════════"
echo ""

# Извлекаем все классы из emitent.php
classes=$(grep -o 'class="[^"]*"' "$EMITENT_PHP" | sed 's/class="//g; s/"//g' | tr ' ' '\n' | sort -u | grep -v '^$' | grep -v '\$')

# Загружаем CSS файлы
critical_css=$(cat "$CRITICAL_CSS" 2>/dev/null)
core_css=$(cat "$CORE_CSS" 2>/dev/null)
emitent_css=$(cat "$EMITENT_CSS" 2>/dev/null)

total=0
found=0
missing=0
missing_classes=""

echo "📋 ПРОВЕРКА КЛАССОВ:"
echo ""

for class in $classes; do
    total=$((total + 1))
    
    # Экранируем спецсимволы для grep
    search_class=$(echo "$class" | sed 's/\./\\./g')
    
    # Ищем класс в любом из файлов
    found_in=""
    
    if echo "$critical_css" | grep -q "\.$search_class"; then
        found_in="Critical"
    fi
    
    if echo "$core_css" | grep -q "\.$search_class"; then
        if [ -n "$found_in" ]; then
            found_in="$found_in + Core"
        else
            found_in="Core"
        fi
    fi
    
    if echo "$emitent_css" | grep -q "\.$search_class"; then
        if [ -n "$found_in" ]; then
            found_in="$found_in + Emitent"
        else
            found_in="Emitent"
        fi
    fi
    
    if [ -n "$found_in" ]; then
        echo "✅ .$class → $found_in"
        found=$((found + 1))
    else
        echo "🔴 .$class → НЕ НАЙДЕН!"
        missing=$((missing + 1))
        missing_classes="$missing_classes\n  - .$class"
    fi
done

echo ""
echo "═══════════════════════════════════════════════════════════"
echo "📊 СТАТИСТИКА:"
echo "═══════════════════════════════════════════════════════════"
echo "Всего классов:    $total"
echo "✅ Найдено:       $found"
echo "🔴 Отсутствует:   $missing"
echo ""

if [ $missing -eq 0 ]; then
    echo "🎉 ВСЕ КЛАССЫ НАЙДЕНЫ! ОТЛИЧНО!"
    echo ""
    echo "✅ Critical CSS покрывает основные стили (inline)"
    echo "✅ Core CSS добавляет utility классы (async)"
    echo "✅ Emitent CSS добавляет page-specific стили (async)"
    echo ""
    echo "💡 Страница эмитента полностью покрыта стилями!"
else
    echo "⚠️  ВНИМАНИЕ: $missing классов отсутствуют в CSS!"
    echo ""
    echo "Отсутствующие классы:$missing_classes"
    echo ""
    echo "🔧 Что делать:"
    echo "  1. Проверь что все CSS файлы собраны:"
    echo "     cd $(dirname $0)"
    echo "     ./build-css.sh"
    echo ""
    echo "  2. Если проблема с emitent.min.css:"
    echo "     - Проверь build/pages/emitent.css"
    echo "     - Добавь недостающие классы"
    echo "     - Запусти ./build-css.sh"
fi

echo ""
echo "═══════════════════════════════════════════════════════════"
echo "📂 ИСПОЛЬЗОВАННЫЕ ФАЙЛЫ:"
echo "═══════════════════════════════════════════════════════════"
echo "emitent.php:      $EMITENT_PHP"
echo "critical.min.css: $CRITICAL_CSS"
echo "core.min.css:     $CORE_CSS"
echo "emitent.min.css:  $EMITENT_CSS"
echo ""
echo "📍 Скрипт запущен из: $(pwd)"
echo ""
