
#!/bin/bash

echo " ПРОВЕРКА INLINE CRITICAL CSS"

echo "════════════════════════════════"



URL="https://deepmax.ru/rusagro/"

html=$(curl -s "$URL")



# Извлекаем <style>

inline_css=$(echo "$html" | grep -oP '<style>.*?</style>' | sed 's/<style>//; s/<\/style>//')



# Размер

size=${#inline_css}

echo " Размер inline CSS: $size символов"



if [ $size -gt 20000 ]; then

    echo "   ✅ Размер правильный!"

else

    echo "   ❌ Слишком мало! Должно быть ~23000"

fi



# Проверяем классы

echo ""

echo " Проверка классов в inline CSS:"



classes=("instrument-card" "emitent-card" "container" "breadcrumbs" "hero")

for class in "${classes[@]}"; do

    if echo "$inline_css" | grep -q "\.$class"; then

        echo "   ✅ .$class найден"

    else

        echo "   ❌ .$class НЕ НАЙДЕН!"

    fi

done



echo ""

