#!/bin/bash

# ============================================================================
# CSS MODULES BUILD SCRIPT v1.0
# ============================================================================

set -e

echo "=================================================="
echo "  CSS MODULES BUILD - deepmax.ru v9.0.0"
echo "=================================================="
echo ""

if [ ! -d "node_modules" ]; then
    echo "⚠️  node_modules not found. Installing dependencies..."
    npm install
    echo ""
fi

mkdir -p dist/pages

echo "🔨 Building critical.min.css..."
npx postcss build/critical-build.css -o dist/critical.min.css
echo "   ✅ critical.min.css created"

echo ""
echo "🔨 Building core.min.css..."
npx postcss build/core-build.css -o dist/core.min.css
echo "   ✅ core.min.css created"

echo ""
echo "🔨 Building page modules..."

for page in bond sector sectors emitent stock catalog-bonds catalog-stocks catalog-emitents; do
    if [ -f "build/pages/${page}-build.css" ]; then
        npx postcss "build/pages/${page}-build.css" -o "dist/pages/${page}.min.css"
        echo "   ✅ ${page}.min.css created"
    fi
done

echo ""
echo "📊 Build statistics:"
echo "=================================================="
ls -lh dist/critical.min.css 2>/dev/null || echo "   critical.min.css not found"
ls -lh dist/core.min.css 2>/dev/null || echo "   core.min.css not found"
ls -lh dist/pages/*.min.css 2>/dev/null || echo "   page modules not found"
echo "=================================================="
echo ""
echo "✅ Build completed successfully!"
