# CSS Modules v9.0.0 - deepmax.ru

Модульная архитектура CSS для финансового портала deepmax.ru с условной загрузкой стилей.

## 📁 Структура

```
css-modules/
├── build/
│   ├── core-full.css          # Полный core CSS (2681 строка)
│   ├── core-build.css         # Build файл для core
│   └── pages/                 # Build файлы для страниц
├── pages/                     # Page-specific модули
│   ├── bond.css               # Bond page (554 строки)
│   ├── sector.css             # Sector page (78 строк)
│   ├── sectors.css            # Sectors page (108 строк)
│   ├── emitent.css            # Emitent page (76 строк)
│   ├── stock.css              # Stock page (пустой, uses bond.css)
│   ├── catalog-bonds.css      # Bonds catalog (786 строк)
│   ├── catalog-stocks.css     # Stocks catalog (464 строки)
│   └── catalog-emitents.css   # Emitents catalog (441 строка)
├── dist/                      # Минифицированные файлы (создаётся при сборке)
├── build-css.sh               # Скрипт сборки
├── postcss.config.js          # Конфигурация PostCSS
├── package.json               # NPM зависимости
└── README.md                  # Этот файл
```

## 🚀 Установка на сервере

### 1. Загрузить на сервер

```bash
scp -r css-modules/ user@server:/var/www/www-root/data/www/deepmax.ru/
```

### 2. Установить зависимости

```bash
cd /var/www/www-root/data/www/deepmax.ru/css-modules
npm install
```

### 3. Собрать CSS

```bash
./build-css.sh
```

### 4. Проверить результат

```bash
ls -lh dist/core.min.css
ls -lh dist/pages/*.min.css
```

Ожидаемые размеры:
- `core.min.css`: ~58-65 KB
- Page модули: ~2-4 KB каждый

## 🔧 Интеграция с head.php

В `site/head.php` УЖЕ НАСТРОЕНА условная загрузка.
Измените путь с `/css/best.css` на `/css-modules/dist/core.min.css`

## ✅ Проверка работоспособности

1. Откройте страницы в браузере
2. Проверьте в DevTools → Network → CSS
3. Убедитесь что загружаются правильные файлы

## 📊 Производительность

**До:** 122 KB на всех страницах  
**После:** ~60 KB (core) + ~2-4 KB (page модуль)  
**Экономия:** ~50-60 KB (≈50%)

## ⚠️ Важные замечания

- Не редактируйте файлы в `dist/` - они перезаписываются при сборке
- После изменений PHP очистите кэш: `rm cache/*.tmp && sudo systemctl restart php8.1-fpm`
- Добавьте версию к файлам на production: `?v=9.0.0`

---

**Версия:** v9.0.0  
**Дата:** 2025-11-04  
**Статус:** Production Ready ✅
