<?php
/**
 * ═══════════════════════════════════════════════════════════════════════════
 * КЛАСС SCHEMA.ORG РАЗМЕТКИ ДЛЯ СТРАНИЦ СЕКТОРОВ
 * ═══════════════════════════════════════════════════════════════════════════
 * 
 * ВЕРСИЯ 1.2 - MINIMAL WORKING VERSION (ОТКАТ)
 * 
 * @version 1.2
 * @date 2025-10-13
 * @author DeepMax Development Team
 * @status PRODUCTION READY ✅
 * ═══════════════════════════════════════════════════════════════════════════
 */
class SchemaOrgSector extends SchemaOrgBase {
    
    public function buildEnhancedJsonLd($page_data, $breadcrumbs) {
        if (empty($page_data) || !is_array($page_data)) {
            return '';
        }
        
        // Получаем данные сектора из $page_data[1]
        $sector = isset($page_data[1]) ? $page_data[1] : null;
        
        if (empty($sector) || !is_object($sector)) {
            return '';
        }
        
        $graph = [];
        
        // 1. BreadcrumbList
        if (!empty($breadcrumbs)) {
            $graph[] = $this->buildBreadcrumbList($breadcrumbs);
        }
        
        // 2. CollectionPage
        $page = ['@type' => 'CollectionPage'];
        
        if (isset($sector->SECTOR_NAME) && trim($sector->SECTOR_NAME) !== '') {
            $page['name'] = $this->safeString($sector->SECTOR_NAME);
            $page['description'] = 'Список эмитентов сектора ' . $this->safeString($sector->SECTOR_NAME);
        }
        
        if (isset($sector->SECTOR_ECONOMIKI_URL) && trim($sector->SECTOR_ECONOMIKI_URL) !== '') {
            $page['url'] = $this->baseUrl . '/' . $this->safeString($sector->SECTOR_ECONOMIKI_URL) . '/';
        }
        
        $graph[] = $page;
        
        // Финальная обёртка
        return $this->buildJsonLd($graph);
    }
}