
#!/bin/bash

echo " Building CSS modules..."

if ! command -v postcss &> /dev/null; then

    echo "❌ ERROR: postcss not found"

    echo "Install: npm install -g postcss-cli postcss-import cssnano autoprefixer"

    exit 1

fi

echo " Building core.min.css..."

postcss css/build/core-build.css -o dist/core.min.css && echo "   ✓ core.min.css ($(du -h dist/core.min.css | cut -f1))"

echo " Building pages..."

for page in bond stock emitent sector sectors catalog-bonds catalog-stocks catalog-emitents; do

    postcss css/build/pages/${page}-build.css -o dist/pages/${page}.min.css && echo "   ✓ ${page}.min.css ($(du -h dist/pages/${page}.min.css | cut -f1))"

done

echo "✅ Build complete!"

