<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h3>Тест 1: Текущая директория</h3>";
echo "До chdir: " . getcwd() . "<br>";

chdir(dirname(__DIR__));

echo "После chdir: " . getcwd() . "<br><br>";

echo "<h3>Тест 2: Файл DB/sectors.php</h3>";
if (file_exists('DB/sectors.php')) {
    echo "✅ Файл найден<br><br>";
    
    echo "<h3>Тест 3: Подключение файла</h3>";
    require_once('DB/sectors.php');
    echo "✅ Файл подключен<br><br>";
    
    echo "<h3>Тест 4: Функция getSectors</h3>";
    if (function_exists('getSectors')) {
        echo "✅ Функция существует<br><br>";
        
        echo "<h3>Тест 5: Получение данных</h3>";
        $sectors = getSectors();
        echo "✅ Получено секторов: " . count($sectors) . "<br><br>";
        
        if (count($sectors) > 0) {
            echo "<h3>Тест 6: Первый сектор</h3>";
            echo "ID: " . $sectors[0]->Id . "<br>";
            echo "Название: " . $sectors[0]->SECTOR_NAME . "<br>";
            echo "Текст: " . (empty($sectors[0]->SECTOR_ECONOMIKI_TEXT) ? '❌ Пусто' : '✅ Есть (' . strlen($sectors[0]->SECTOR_ECONOMIKI_TEXT) . ' символов)') . "<br>";
        }
    } else {
        echo "❌ Функция не найдена";
    }
} else {
    echo "❌ Файл не найден<br>";
    echo "Полный путь: " . realpath('DB/sectors.php');
}
?>