<?php
// /var/www/www-root/data/www/deepmax.ru/api/test-load.php

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "=== ДИАГНОСТИКА ===\n\n";

// Проверка 1: Текущая директория
echo "1. Текущая директория: " . getcwd() . "\n\n";

// Проверка 2: Существует ли файл sectors.php
$sectorsPath = '../DB/sectors.php';
echo "2. Путь к sectors.php: " . realpath($sectorsPath) . "\n";
echo "   Файл существует: " . (file_exists($sectorsPath) ? 'ДА' : 'НЕТ') . "\n\n";

// Проверка 3: Попытка подключения
echo "3. Попытка подключения sectors.php:\n";
try {
    require_once($sectorsPath);
    echo "   Подключение успешно\n\n";
} catch (Exception $e) {
    echo "   ОШИБКА: " . $e->getMessage() . "\n\n";
    exit;
}

// Проверка 4: Существует ли функция
echo "4. Функция getSectors существует: " . (function_exists('getSectors') ? 'ДА' : 'НЕТ') . "\n\n";

// Проверка 5: Вызов функции
echo "5. Попытка вызова getSectors():\n";
try {
    $sectors = getSectors();
    echo "   Успешно. Получено секторов: " . count($sectors) . "\n\n";
    
    // Проверка структуры первого сектора
    if (count($sectors) > 0) {
        echo "6. Структура первого сектора:\n";
        print_r($sectors[0]);
    }
} catch (Exception $e) {
    echo "   ОШИБКА: " . $e->getMessage() . "\n\n";
}
?>