<?php
/**
 * ═══════════════════════════════════════════════════════════════════════════
 * API: ЗАГРУЗКА ОПИСАНИЯ СЕКТОРА (КРАТКОЕ)
 * ═══════════════════════════════════════════════════════════════════════════
 * 
 * Версия: 1.2.0 FIXED
 * Дата: 2025-10-15
 * Endpoint: /api/load-sector-description.php?id={sector_id}
 * Статус: PRODUCTION READY
 * 
 * ИЗМЕНЕНИЯ v1.2.0:
 *   🔥 FIX: Убран esc() для корректного отображения HTML разметки
 *   📝 Контент содержит <details>, <summary>, <p> теги
 *   📝 Безопасность обеспечена на уровне админки (правило 9)
 * 
 * ИЗМЕНЕНИЯ v1.0.1:
 *   🔒 Добавлена проверка функции esc() (не используется для HTML)
 *   📝 Обновлена документация
 * 
 * НАЗНАЧЕНИЕ:
 *   Загрузка краткого описания сектора для lazy loading в sectors.php
 *   Используется site.js v1.1.0 для динамической подгрузки описаний
 * 
 * ПАРАМЕТРЫ:
 *   id - ID сектора (int, 1-25)
 * 
 * ВОЗВРАЩАЕТ:
 *   Success: HTML текст описания сектора (с HTML разметкой)
 *   Error 400: Некорректный ID
 *   Error 404: Сектор не найден или описание отсутствует
 * 
 * КЭШИРОВАНИЕ:
 *   Cache-Control: public, max-age=3600 (1 час)
 * 
 * БЕЗОПАСНОСТЬ:
 *   Контент из БД выводится без экранирования, т.к.:
 *   - Содержит HTML разметку (<details>, <summary>, <p>)
 *   - Добавляется только через защищённую админку
 *   - Валидируется при сохранении в БД
 * 
 * ═══════════════════════════════════════════════════════════════════════════
 */

error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

// Устанавливаем заголовки
header('Content-Type: text/html; charset=utf-8');

// Валидация ID сектора
$sectorId = intval($_GET['id'] ?? 0);

// Расширенная проверка ID с запасом на будущее
if ($sectorId < 1 || $sectorId > 25) {
    http_response_code(400);
    error_log("load-sector-description.php: Некорректный ID: " . $sectorId);
    die('Некорректный ID сектора');
}

// Меняем рабочую директорию на корень сайта
chdir(dirname(__DIR__));

// Подключаем конфигурацию
require_once('config.php');

// Подключаемся к базе данных
require_once('DB/db.php');
$db = new Database();

// Подключаем модуль секторов
require_once('DB/sectors.php');

// Получаем все сектора
$sectors = getSectors();
$sector = null;

// Ищем нужный сектор по ID
foreach ($sectors as $s) {
    if ($s->Id == $sectorId) {
        $sector = $s;
        break;
    }
}

// Проверка: сектор найден?
if (!$sector) {
    error_log("load-sector-description.php: Сектор ID={$sectorId} не найден в базе");
    http_response_code(404);
    die('Сектор не найден');
}

// Проверка: есть ли описание?
if (empty($sector->SECTOR_ECONOMIKI_TEXT)) {
    error_log("load-sector-description.php: У сектора ID={$sectorId} нет описания");
    http_response_code(404);
    die('Описание отсутствует');
}

// Кэширование на 1 час (3600 секунд)
header('Cache-Control: public, max-age=3600');

// FIX v1.2.0: Выводим HTML "как есть" (БЕЗ esc)
// Безопасность обеспечена на уровне админки (правило 9: If it ain't broke, don't fix it)
echo $sector->SECTOR_ECONOMIKI_TEXT;