<?
require_once('DB/classes/trade.php');

function addTrade($trade){
   global $db;
   $stmt = $db->connection
      ->prepare("INSERT INTO Sdelki(Data, Time, Operation, Tiket, Price, Lots, Sum, AM, Y, Profit) 
      VALUES (?,?,?,?,?,?,?,?,?,?)");
   
   $stmt->bind_param("ssssdidsid", 
      $trade->Data,
      $trade->Time,
      $trade->Operation,
      $trade->Tiket,
      $trade->Price,
      $trade->Lots,
      $trade->Sum,
      $trade->AM,
      $trade->Y,
      $trade->Profit
   );
   $stmt->execute();
}   

function getLastBuyTradeSum($tiket){
   global $db;
   $stmt = $db->connection->prepare('SELECT Sum FROM Sdelki WHERE Tiket=? AND Operation="Buy" ORDER BY Id DESC LIMIT 1');
   $stmt->bind_param("s", $tiket);
   $stmt->execute();
   $result = $stmt->get_result();
   if ($result->num_rows > 0){
      return $result->fetch_array()[0];
   }else{
      return null;
   }
}

function getTradesByMonth(){
   global $db;
   $trades = [];
   $query = 'SELECT * FROM Sdelki';
   $result = $db->connection->query($query);
   if ($result->num_rows > 0){
      while ($trade = $result->fetch_object('Trade')){
         array_push($trades, $trade);
      }    
   }else{
      return null;
   }

   $dates = [];
   $trades_by_month = [];

   $year_str = 0;
   $month = 0;
   $month_str = '';
   for($i = 0; $i < count($trades); $i++){
      $year_str = substr($trades[$i]->Data, 0, 4);
      $month = intval(substr($trades[$i]->Data, 5, 2));
      switch ($month) {
         case 1:
            $month_str = 'Январь';
            break;
         case 2:
            $month_str = 'Февраль';
            break;
         case 3:
            $month_str = 'Март';
            break;
         case 4:
            $month_str = 'Апрель';
            break;
         case 5:
            $month_str = 'Май';
            break;
         case 6:
            $month_str = 'Июнь';
            break;
         case 7:
            $month_str = 'Июль';
            break;
         case 8:
            $month_str = 'Август';
            break;
         case 9:
            $month_str = 'Сентябрь';
            break;
         case 10:
            $month_str = 'Октябрь';
            break;
         case 11:
            $month_str = 'Ноябрь';
            break;
         case 12:
            $month_str = 'Декабрь';
            break;
      }

      $month = strval($month);
      if(strlen($month) == 1){
         $month = '0' . $month;
      }

      if($dates[$year_str . ', ' . $month_str] == null){
         $dates[$year_str . ', ' . $month_str] = [
            'DateNum' => intval($year_str . $month),
            'Date' => $year_str . ', ' . $month_str,
            'SumBuy' => 0,
            'SumSell' => 0,
            'OpQty' => 0,
            'ProfitSum' => 0
         ];
      }

      if($trades[$i]->Operation == 'Buy'){
         $dates[$year_str . ', ' . $month_str]['SumBuy'] += $trades[$i]->Sum;
      }else{
         $dates[$year_str . ', ' . $month_str]['SumSell'] -= $trades[$i]->Sum;
      }

      $dates[$year_str . ', ' . $month_str]['OpQty'] += 1;
      $dates[$year_str . ', ' . $month_str]['ProfitSum'] += $trades[$i]->Profit;
   }

   foreach ($dates as $date => $values){
      array_push($trades_by_month, $values);
   }

   usort($trades_by_month, function($a, $b) {
      if ($a['DateNum'] == $b['DateNum']){
         return 0;
      }else{
         return $a['DateNum'] < $b['DateNum'] ? 1 : -1;
      }
   });

   return $trades_by_month;
}

// $month формат '2024-09'
function getTrades($month = null){
   global $db;
   $trades = [];

   $query = '';
   if($month == null)
      $query = 'SELECT * FROM Sdelki';
   else
      $month = intval($month);
      $query = 'SELECT * FROM Sdelki WHERE (Data LIKE "' . $month . '%")';

   $result = $db->connection->query($query);
   if ($result->num_rows > 0){
      while ($trade = $result->fetch_object('Trade')){
         array_push($trades, $trade);
      }    
   }else{
      return null;
   }

   return $trades;
}