<?
require_once('DB/classes/settings.php');

function addSettings($settings){
   global $db;

   $stmt = $db->connection
      ->prepare("INSERT INTO Settings(Data, Time, Tiket, Invest, TA, Rlot, Y) 
      VALUES (?,?,?,?,?,?,?)");
   
   $stmt->bind_param("sssidii", 
      $settings->Data,
      $settings->Time,
      $settings->Tiket,
      $settings->Invest,
      $settings->TA,
      $settings->Rlot,
      $settings->Y,
   );
   $stmt->execute();
}

function getSettings($part = null, $qty = null){
   global $db;
   $settings = [];

   $query = '';

   $rows_qty = getSettingsQty();

   if($part != null && $qty != null){
      $from = $rows_qty - $qty * $part;
      if($from < 0){
         $qty = $qty + $from;
         $from = 0;
      }
      $query = 'SELECT * FROM Settings ORDER BY Id LIMIT ' . $from . ', ' . $qty;
   }else{
      $query = 'SELECT * FROM Settings';
   }

   $result = $db->connection->query($query);
   if ($result->num_rows > 0){
      while ($setting = $result->fetch_object('Settings')){
         array_push($settings, $setting);
      }    
   }else{
      return null;
   }

   return $settings;
}

function getSettingsQty(){
   global $db;
   $query = 'SELECT * FROM Settings';
   $result = $db->connection->query($query);
   return $result->num_rows;
}
