<?
require_once('DB/classes/security-current-params.php');
require_once('DB/securities.php');

function addSecurityCurrentParams($security_current_params){
   global $db;
   $data = getSecurityIdAndTableName($security_current_params->ClassCode, $security_current_params->SecCode, $security_current_params->SecSubtypeStatic);
   if($data[0] == null) return;

   $stmt = $db->connection
      ->prepare("INSERT INTO SecuritiesCurrentParams(
         Timestamp, 
         TableName, 
         SecurityId, 
         SecSubtypeStatic, 
         PrevValtoday, 
         PrevSettlePrice, 
         Last,
         CurrentValue,
         LastValue) 
      VALUES (?,?,?,?,?,?,?,?,?)");
   
   $stmt->bind_param("ssisddddd", 
      $security_current_params->Timestamp,
      $data[1], 
      $data[0], 
      $security_current_params->SecSubtypeStatic, 
      $security_current_params->PrevValtoday, 
      $security_current_params->PrevSettlePrice, 
      $security_current_params->Last, 
      $security_current_params->CurrentValue, 
      $security_current_params->LastValue
   );
   $stmt->execute();
}
function getSecurityCurrentParams($class_code, $sec_code, $sec_subtype_static){
   global $db;
   $data = getSecurityIdAndTableName($class_code, $sec_code, $sec_subtype_static);
   if($data[0] == null) return;
   $stmt = $db->connection->prepare('SELECT * FROM SecuritiesCurrentParams WHERE SecurityId=? AND TableName=? ORDER BY Id DESC LIMIT 1');
   $stmt->bind_param("is", $data[0], $data[1]);
   $stmt->execute();
   $result = $stmt->get_result();
   if ($result->num_rows > 0){
      return $result->fetch_object('SecurityCurrentParams');
   }else{
      return null;
   }
}