<?
require_once('DB/classes/security.php');

function addSecurity($security){
   global $db;

   $table_name = '';
   $lower = mb_strtolower($security->SecSubtypeStatic);
   if($security->ClassCode == 'INDX'){
      $table_name = 'QUIK_Index';
   }else if(!str_contains($lower, 'опцион') && str_contains($lower, 'акци')){
      $table_name = 'QUIK_Akcii';
   }else if(str_contains($lower, 'облигац')){
      $table_name = 'QUIK_Obligacii';
   }
   if($table_name !== ''){
      $stmt = $db->connection
         ->prepare("INSERT INTO " . $table_name . " (
            Timestamp, 
            ClassCode, 
            SecCode, 
            SecTypeStatic, 
            SecSubtypeStatic, 
            SecName, 
            ShortName, 
            ISIN, 
            RegNumber, 
            ClassName, 
            FaceValue, 
            FaceUnit, 
            Scale, 
            MinPriceStep, 
            SecStatus, 
            LotSize, 
            IssueSize, 
            QuoteBasis, 
            SettleCode, 
            CurrencyId,         
            IssueSizePlaced,
            MatDate,
            AccruedInt,
            CouponValue,
            SettleDate,
            CouponPeriod,
            NextCoupon,
            BuyBackPrice,
            CFI,
            DaysToMatDate,
            SecComment,
            BuyBackDate,
            StockCode,
            SEDOL,
            RIC,
            CUSIP,
            StockName,
            BloombergID,
            AgentID,
            ComplexProduct,
            AuctionID,
            Issuer
         ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
      
      $stmt->bind_param("ssssssssssdsidsiisssisddsisdssssssssssssss", 
         $security->Timestamp, 
         $security->ClassCode, 
         $security->SecCode, 
         $security->SecTypeStatic, 
         $security->SecSubtypeStatic, 
         $security->SecName, 
         $security->ShortName, 
         $security->ISIN, 
         $security->RegNumber, 
         $security->ClassName, 

         $security->FaceValue, 
         $security->FaceUnit, 
         $security->Scale, 

         $security->MinPriceStep, 
         $security->SecStatus, 
         $security->LotSize, 
         $security->IssueSize, 

         $security->QuoteBasis, 
         $security->SettleCode, 
         $security->CurrencyId, 
         $security->IssueSizePlaced, 

         $security->MatDate, 
         $security->AccruedInt, 
         $security->CouponValue, 
         $security->SettleDate, 

         $security->CouponPeriod, 
         $security->NextCoupon, 
         $security->BuyBackPrice,

         $security->CFI,
         $security->DaysToMatDate,
         $security->SecComment,
         $security->BuyBackDate,
         $security->StockCode,
         $security->SEDOL,
         $security->RIC,
         $security->CUSIP,
         $security->StockName,
         $security->BloombergID,
         $security->AgentID,
         $security->ComplexProduct,
         $security->AuctionID,
         $security->Issuer
      );
      $stmt->execute();
   }
}
function getSecurityIdAndTableName($class_code, $sec_code, $sec_subtype_static){
   global $db;
   $lower = mb_strtolower($sec_subtype_static);
   $table_name = '';
   if($class_code == 'INDX'){
      $table_name = 'QUIK_Index';
   }else if(!str_contains($lower, 'опцион') && str_contains($lower, 'акци')){
      $table_name = 'QUIK_Akcii';
   }else if(str_contains($lower, 'облигац')){
      $table_name = 'QUIK_Obligacii';
   }
   if($table_name !== ''){
      $stmt = $db->connection->prepare('SELECT Id FROM ' . $table_name . ' WHERE ClassCode=? AND SecCode=?');
      $stmt->bind_param("ss", $class_code, $sec_code);
      $stmt->execute();
      $result = $stmt->get_result();
      if ($result->num_rows > 0){
         return [$result->fetch_array()[0], $table_name];
      }else{
         return [null, null];
      }
   }
   return [null, null];
}
function getSecurity($class_code, $sec_code){
   global $db;
   $stmt = $db->connection->prepare('SELECT * FROM Securities WHERE ClassCode=? AND SecCode=? LIMIT 1');
   $stmt->bind_param("ss", $class_code, $sec_code);
   $stmt->execute();
   $result = $stmt->get_result();
   if ($result->num_rows > 0){
      return $result->fetch_object('Security');
   }else{
      return null;
   }
}
function getFirstSecurityByClass($class_code){
   global $db;
   $stmt = $db->connection->prepare('SELECT * FROM Securities WHERE ClassCode=? LIMIT 1');
   $stmt->bind_param("s", $class_code);
   $stmt->execute();
   $result = $stmt->get_result();
   if ($result->num_rows > 0){
      return $result->fetch_object('Security');
   }else{
      return null;
   }
}
function getSecuritiesByClassCodes($class_codes){
   global $db;
   $query = 'SELECT DISTINCT SecCode FROM Securities WHERE';
   if(count($class_codes) == 1){
      $query .=  ' ClassCode="' . $class_codes[0] . '"';
   }else{
      for($i=0;$i<count($class_codes);$i++){
         if($i == 0){
            $query .= ' ClassCode="' . $class_codes[$i] . '"';
         }else{
            $query .= ' OR ClassCode="' . $class_codes[$i] . '"';
         }            
      }
   }
   $query .= ' ORDER BY SecCode';

   $result = $db->connection->query($query);

   $sec_codes = [];

   for($i=0;$i<$result->num_rows;$i++){
      array_push($sec_codes, $result->fetch_array()[0]);
   }

   return $sec_codes;
}
function getSecuritiesByNotClassCodes($class_codes){
   global $db;
   $query = 'SELECT DISTINCT SecCode FROM Securities WHERE';
   if(count($class_codes) == 1){
      $query .=  ' NOT ClassCode="' . $class_codes[0] . '"';
   }else{
      for($i=0;$i<count($class_codes);$i++){
         if($i == 0){
            $query .= ' NOT ClassCode="' . $class_codes[$i] . '"';
         }else{
            $query .= ' AND NOT ClassCode="' . $class_codes[$i] . '"';
         }            
      }
   }
   $query .= ' ORDER BY SecCode';

   $result = $db->connection->query($query);

   $sec_codes = [];

   for($i=0;$i<$result->num_rows;$i++){
      array_push($sec_codes, $result->fetch_array()[0]);
   }

   return $sec_codes;
}
function updateSecurity($security){
   global $db;
   $data = getSecurityIdAndTableName($security->ClassCode, $security->SecCode, $security->SecSubtypeStatic);
   if($data[0] == null){
      addSecurity($security);
   }else{
      $table_name = '';
      $lower = mb_strtolower($security->SecSubtypeStatic);
      if($security->ClassCode == 'INDX'){
         $table_name = 'QUIK_Index';
      }else if(!str_contains($lower, 'опцион') && (str_contains($lower, 'акци') or str_contains($lower, 'распис') or str_contains($lower, 'паи'))){
         $table_name = 'QUIK_Akcii';
      }else if(str_contains($lower, 'облигац') or str_contains($lower, 'ипотечн')){
         $table_name = 'QUIK_Obligacii';
      }
      if($table_name !== ''){
         $stmt = $db->connection
         ->prepare("UPDATE " . $table_name . " SET
            Timestamp=?, 
            ClassCode=?, 
            SecCode=?, 
            SecTypeStatic=?, 
            SecSubtypeStatic=?, 
            SecName=?, 
            ShortName=?, 
            ISIN=?, 
            RegNumber=?, 
            ClassName=?, 
            FaceValue=?, 
            FaceUnit=?, 
            Scale=?, 
            MinPriceStep=?, 
            SecStatus=?, 
            LotSize=?, 
            IssueSize=?, 
            QuoteBasis=?, 
            SettleCode=?, 
            CurrencyId=?,         
            IssueSizePlaced=?,
            MatDate=?,
            AccruedInt=?,
            CouponValue=?,
            SettleDate=?,
            CouponPeriod=?,
            NextCoupon=?,
            BuyBackPrice=?,            
            CFI=?,
            DaysToMatDate=?,
            SecComment=?,
            BuyBackDate=?,
            StockCode=?,
            SEDOL=?,
            RIC=?,
            CUSIP=?,
            StockName=?,
            BloombergID=?,
            AgentID=?,
            ComplexProduct=?,
            AuctionID=?,
            Issuer=? WHERE Id=?"
         );
         $stmt->bind_param("ssssssssssdsidsiisssisddsisdissssssssssssss", 
            $security->Timestamp, 
            $security->ClassCode, 
            $security->SecCode, 
            $security->SecTypeStatic, 
            $security->SecSubtypeStatic, 
            $security->SecName, 
            $security->ShortName, 
            $security->ISIN, 
            $security->RegNumber, 
            $security->ClassName, 
            $security->FaceValue, 
            $security->FaceUnit, 
            $security->Scale, 
            $security->MinPriceStep, 
            $security->SecStatus, 
            $security->LotSize, 
            $security->IssueSize, 
            $security->QuoteBasis, 
            $security->SettleCode, 
            $security->CurrencyId, 
            $security->IssueSizePlaced, 
            $security->MatDate, 
            $security->AccruedInt, 
            $security->CouponValue, 
            $security->SettleDate, 
            $security->CouponPeriod, 
            $security->NextCoupon, 
            $security->BuyBackPrice, 
            $security->CFI,
            $security->DaysToMatDate,
            $security->SecComment,
            $security->BuyBackDate,
            $security->StockCode,
            $security->SEDOL,
            $security->RIC,
            $security->CUSIP,
            $security->StockName,
            $security->BloombergID,
            $security->AgentID,
            $security->ComplexProduct,
            $security->AuctionID,
            $security->Issuer,
            $security_id
         );
         if ($stmt->execute())
            my_log('stmt GOOD');
         else
            my_log('stmt NO GOOD');
      }
   }
}
function getSecurityQty(){
   global $db;
   $query = 'SELECT * FROM Securities';
   $result = $db->connection->query($query);
   return $result->num_rows;
}
function getSecurityPart($part = null, $qty = null){
   global $db;
   $security = [];

   $query = '';

   $rows_qty = getSecurityQty();

   if($part != null && $qty != null){
      $from = $rows_qty - $qty * $part;
      if($from < 0){
         $qty = $qty + $from;
         $from = 0;
      }
      $query = 'SELECT * FROM Securities ORDER BY Id LIMIT ' . $from . ', ' . $qty;
   }else{
      $query = 'SELECT * FROM Securities';
   }

   $result = $db->connection->query($query);
   if ($result->num_rows > 0){
      while ($_security = $result->fetch_object('Security')){
         array_push($security, $_security);
      }    
   }else{
      return null;
   }

   return $security;
}
function getSecurityClassCode($sec_code, $good_class_codes){
   global $db;
   $query = 'SELECT ClassCode FROM Securities WHERE';
   if(count($good_class_codes) == 1){
      $query .=  ' SecCode="' . $sec_code . '" AND ClassCode="' . $good_class_codes[0] . '" LIMIT 1';
   }else{
      $query .=  ' SecCode="' . $sec_code . '" AND (';
      for($i=0;$i<count($good_class_codes);$i++){
         if($i == 0){
            $query .= ' ClassCode="' . $good_class_codes[$i] . '"';
         }else{
            $query .= ' OR ClassCode="' . $good_class_codes[$i] . '"';
         }            
      }
      $query .=  ') LIMIT 1';
   }
   $result = $db->connection->query($query);

   return $result->fetch_array()[0];
}
