<?
require_once('DB/classes/pos.php');

function addPos($pos){
   global $db;

   $stmt = $db->connection
      ->prepare("INSERT INTO LotsDayStart(Data, Time, Tiket, LotsStart, InLots, Price, Summ) 
      VALUES (?,?,?,?,?,?,?)");
   
   $stmt->bind_param("sssiidd", 
      $pos->Data,
      $pos->Time,
      $pos->Tiket,
      $pos->LotsStart,
      $pos->InLots,
      $pos->Price,
      $pos->Summ
   );
   $stmt->execute();
}

function getPoses($part = null, $qty = null){
   global $db;
   $poses = [];

   $query = '';

   $rows_qty = getPosesQty();

   if($part != null && $qty != null){
      $from = $rows_qty - $qty * $part;
      if($from < 0){
         $qty = $qty + $from;
         $from = 0;
      }
      $query = 'SELECT * FROM LotsDayStart ORDER BY Id LIMIT ' . $from . ', ' . $qty;
   }else{
      $query = 'SELECT * FROM LotsDayStart';
   }

   $result = $db->connection->query($query);
   if ($result->num_rows > 0){
      while ($pos = $result->fetch_object('Pos')){
         array_push($poses, $pos);
      }    
   }else{
      return null;
   }

   return $poses;
}

function getPosesQty(){
   global $db;
   $query = 'SELECT * FROM LotsDayStart';
   $result = $db->connection->query($query);
   return $result->num_rows;
}