<?
require_once('DB/classes/money.php');

function addMoney($money){
   global $db;

   $stmt = $db->connection
      ->prepare("INSERT INTO Money(Data, Time, Money) 
      VALUES (?,?,?)");
   
   $stmt->bind_param("ssd", 
      $money->Data,
      $money->Time,
      $money->Money
   );
   $stmt->execute();
}

function getMoney($part = null, $qty = null){
   global $db;
   $money = [];

   $query = '';

   $rows_qty = getMoneyQty();

   if($part != null && $qty != null){
      $from = $rows_qty - $qty * $part;
      if($from < 0){
         $qty = $qty + $from;
         $from = 0;
      }
      $query = 'SELECT * FROM Money ORDER BY Id LIMIT ' . $from . ', ' . $qty;
   }else{
      $query = 'SELECT * FROM Money';
   }

   $result = $db->connection->query($query);
   if ($result->num_rows > 0){
      while ($_money = $result->fetch_object('Money')){
         array_push($money, $_money);
      }    
   }else{
      return null;
   }

   return $money;
}

function getMoneyQty(){
   global $db;
   $query = 'SELECT * FROM Money';
   $result = $db->connection->query($query);
   return $result->num_rows;
}
