<?php
/**
 * menu.php v7.1 PAGE_URL_FALLBACK
 * 
 * DeepMax.ru - Main Navigation Menu
 * Date: 2025-10-20
 * Status: PRODUCTION READY
 * 
 * Changelog v7.1 PAGE_URL_FALLBACK:
 * - FIXED: Added fallback for $page_url variable
 * - Prevents "Undefined variable $page_url" warnings
 * - Ensures menu always has access to current page URL
 * 
 * Changelog v7.0:
 * - Removed all wb_* classes and IDs
 * - New semantic structure with <nav class="main-nav">
 * - Preserved all PHP logic (getMenuItems, aria-current, active class)
 * - CSP compatible (no inline styles)
 * - Mobile-first responsive design
 * - Accessibility: ARIA attributes, keyboard navigation
 * 
 * Previous version: v6.x with wb_element structure
 */

// v7.1 PAGE_URL_FALLBACK: Fallback для $page_url если не определена в global scope
// Это предотвращает "Undefined variable $page_url" ошибки
if (!isset($page_url)) {
    $page_url = trim($_SERVER['REQUEST_URI'] ?? '/', '/');
}
?>

<nav class="main-nav" aria-label="Главное меню">
    <button class="nav-toggle" type="button" aria-label="Открыть меню" aria-expanded="false">
        <span class="nav-toggle-bar"></span>
        <span class="nav-toggle-bar"></span>
        <span class="nav-toggle-bar"></span>
    </button>
    
    <ul class="nav-menu" role="menubar">
        <?php
        // Главная страница
        $is_home = (empty($page_url) || $page_url == '/' || $page_url == 'index');
        $home_class = $is_home ? ' active' : '';
        $home_aria = $is_home ? ' aria-current="page"' : '';
        
        // SEO title для главной страницы
        $home_title = 'Главная страница ' . htmlspecialchars(SITE_NAME);
        
        echo '<li class="nav-item' . $home_class . '" role="none">';
        echo '<a href="/" class="nav-link" role="menuitem"' . $home_aria . ' title="' . $home_title . '">';
        echo htmlspecialchars(SITE_NAME);
        echo '</a>';
        echo '</li>';
        
        // Остальные пункты меню из БД
        $menu_items = getMenuItems();
        
        if (!empty($menu_items)) {
            foreach ($menu_items as $item) {
                $clean_url = trim($item->MENU_url, '/');
                $url = '/' . htmlspecialchars($clean_url) . '/';
                $name = htmlspecialchars($item->MENU_name);
                $is_current = ($clean_url == trim($page_url, '/'));
                
                $li_class = $is_current ? ' active' : '';
                $aria_current = $is_current ? ' aria-current="page"' : '';
                
                // SEO title атрибут (ПРАВИЛО 19) - используем исходное имя для title
                $title = htmlspecialchars('Перейти в раздел: ' . $item->MENU_name);
                
                echo '<li class="nav-item' . $li_class . '" role="none">';
                echo '<a href="' . $url . '" class="nav-link" role="menuitem"' . $aria_current . ' title="' . $title . '">';
                echo $name;
                echo '</a>';
                echo '</li>';
            }
        }
        ?>
    </ul>
</nav>

<!-- Mobile menu overlay -->
<div class="nav-overlay" aria-hidden="true"></div>