<?php
echo "\n<!-- HEADER.PHP EXECUTED -->\n";
?>

<?php
/**
 * header.php v7.1 COMPLETE
 * 
 * DeepMax.ru - Шапка сайта
 * Дата: 2025-11-10
 * Статус: PRODUCTION READY
 * 
 * Changelog v7.1 COMPLETE:
 * - Добавлен контейнер .header-content для правильного layout
 * - Добавлен .site-logo с логотипом и названием сайта
 * - Исправлена структура: header-content > (site-logo + main-nav)
 * - Соответствие стилям из critical-build.css
 * 
 * Changelog v7.0:
 * - Убраны все wb_* классы и ID
 * - Новая семантическая структура с <header class="site-header">
 * - Чистый HTML без лишних div оберток
 * - Подключает menu.php v7.0 SEMANTIC
 * - Автоопределение пути: работает из корня ИЛИ из папки /site/
 * 
 * Предыдущая версия: v6.x со структурой wb_element
 * 
 * ВАЖНО: Путь к menu.php определяется автоматически:
 * - Если header.php в /site/ → подключает 'menu.php'
 * - Если header.php в корне → подключает 'site/menu.php'
 */

// Определяем путь к menu.php в зависимости от расположения файла
$menu_path = file_exists(__DIR__ . '/menu.php') ? 'menu.php' : 'site/menu.php';
?>

<header class="site-header">
    <div class="header-content">
        <div class="site-logo">
            <a href="/" title="Главная страница DeepMax.ru">
                🔷 <?php echo htmlspecialchars(SITE_NAME); ?>
            </a>
        </div>
        <?php include $menu_path; ?>
    </div>
</header>