<?php
echo "\n<!-- HEAD.PHP EXECUTED -->\n";
?>

<?php

if (!defined('SITE_URL') || !filter_var(SITE_URL, FILTER_VALIDATE_URL)) {
    error_log('Security: Invalid SITE_URL configuration');
    http_response_code(500);
    die('Configuration error');
}

// ===== ОБРАБОТКА ПЕРЕМЕННЫХ =====
$request_uri = isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : '';
$user_agent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';
$query_string = isset($_SERVER['QUERY_STRING']) ? $_SERVER['QUERY_STRING'] : '';
$remote_ip = isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : 'unknown';

// ===== ЕДИНЫЙ БЛОК ЗАГОЛОВКОВ (ОПТИМИЗАЦИЯ) =====
if (!headers_sent()) {
    // Базовые заголовки УЖЕ установлены в .htaccess:
    // - X-Content-Type-Options, X-Frame-Options, X-XSS-Protection
    // - Referrer-Policy
    // - header_remove Server/X-Powered-By
    
    // ТОЛЬКО уникальные заголовки, которых НЕТ в .htaccess:
    header('Permissions-Policy: geolocation=(), microphone=(), camera=(), payment=()');
    header('Cross-Origin-Opener-Policy: same-origin');
    
    // Кэширование для динамических страниц
    if ($request_uri) {
        $parsed_url = parse_url($request_uri, PHP_URL_PATH);
        if ($parsed_url !== false) {
            $file_extension = pathinfo($parsed_url, PATHINFO_EXTENSION);
            $static_extensions = ['ttf', 'otf', 'woff', 'woff2', 'css', 'js', 'png', 'jpg', 'jpeg', 'gif', 'ico', 'svg', 'webp'];
            
            if (!in_array(strtolower($file_extension), $static_extensions)) {
                header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
                header('Pragma: no-cache'); 
                header('Expires: 0');
            }
        }
    }
    
    // Динамический CSP
    $site_domain = parse_url(SITE_URL, PHP_URL_HOST);
    if ($site_domain && preg_match('/^[a-zA-Z0-9.-]+$/', $site_domain)) {
        $safe_font_src = 'https://' . $site_domain;
    } else {
        $safe_font_src = "'self'"; // Fallback
    }

    // ПРИМЕЧАНИЕ: cdn.jsdelivr.net оставлен в CSP на случай будущих библиотек
    // Bootstrap удалён из HTML, но CDN разрешён для возможных jQuery/других библиотек
    // Если CDN не нужен вообще - можно убрать https://cdn.jsdelivr.net из script-src и style-src
$csp_policy = "default-src 'self'; " .
    "script-src 'self' https://www.googletagmanager.com https://www.google-analytics.com https://mc.yandex.ru; " .
    "style-src 'self' 'unsafe-inline'; " .
    "font-src 'self' " . $safe_font_src . "; " .
    "img-src 'self' data: https://www.google-analytics.com https://mc.yandex.ru; " .
    "connect-src 'self' https://www.google-analytics.com https://mc.yandex.ru; " .
    "frame-ancestors 'none'; " .
    "base-uri 'self'; " .
    "object-src 'none';";

    header("Content-Security-Policy: " . $csp_policy);
}

// ===== ЗАЩИТА ОТ АТАК =====
if ($request_uri) {
    // Directory traversal с проверкой ошибок
    $traversal_check = preg_match('/\.\.[\/\\\\]/', $request_uri);
    if ($traversal_check === false) {
        error_log('Security: regex error in traversal check');
    } elseif ($traversal_check === 1) {
        error_log("Security Alert: Directory traversal attempt. IP: $remote_ip, URI: $request_uri");
        http_response_code(403);
        die();
    }

    // NULL byte injection
    if (strpos($request_uri, "\0") !== false) {
        error_log("Security Alert: NULL byte injection. IP: $remote_ip, URI: $request_uri");
        http_response_code(400);
        die();
    }
}

// ===== ЗАЩИЩЕННОЕ ЛОГИРОВАНИЕ =====
static $log_count = 0;
if ($log_count < 3) { // Rate limiting
    $critical_patterns = ['eval(', 'base64_decode', '<script', 'union select'];
    foreach ($critical_patterns as $pattern) {
        if (stripos($request_uri . $query_string . $user_agent, $pattern) !== false) {
            error_log("Security Alert: Pattern '$pattern' detected. IP: $remote_ip");
            $log_count++;
            break;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ru">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<!-- Critical font preloads: Inter family -->
<link rel="preload" href="/fonts/Inter-Regular.woff2" as="font" type="font/woff2" crossorigin fetchpriority="high">
<link rel="preload" href="/fonts/Inter-Medium.woff2" as="font" type="font/woff2" crossorigin>
<link rel="preload" href="/fonts/Inter-SemiBold.woff2" as="font" type="font/woff2" crossorigin>
<link rel="preload" href="/fonts/Inter-Bold.woff2" as="font" type="font/woff2" crossorigin>
<link rel="preload" href="/fonts/Inter-ExtraBold.woff2" as="font" type="font/woff2" crossorigin>

<!-- Expert -->
<meta name="author" content="DeepMax.ru">
<meta name="content-language" content="ru-RU">
<meta name="generator" content="DeepMax Engine v7.0.5">

<!-- Preconnect to analytics -->
<link rel="preconnect" href="https://www.google-analytics.com" crossorigin>
<link rel="preconnect" href="https://mc.yandex.ru" crossorigin>

<!-- SEO -->
<title><?php echo htmlspecialchars($title ?? 'DeepMax.ru - Ценные бумаги', ENT_QUOTES, 'UTF-8'); ?></title>
<meta name="description" content="<?php echo htmlspecialchars($description ?? 'Информация о ценных бумагах на Московской бирже', ENT_QUOTES, 'UTF-8'); ?>">
<meta name="keywords" content="<?php echo htmlspecialchars($keywords ?? 'акции, облигации, ценные бумаги, московская биржа', ENT_QUOTES, 'UTF-8'); ?>">
<meta name="robots" content="noindex, nofollow">
<meta name="language" content="ru">
<meta name="geo.region" content="RU">
<meta name="geo.placename" content="Россия">
<meta name="distribution" content="global">

<!-- Цвет интерфейса браузера -->
<meta name="theme-color" content="#4a9d9d">
<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">

<link rel="canonical" href="<?php echo SITE_URL . ($og_url ?? ''); ?>">
<base href="<?php echo SITE_URL; ?>">

<!-- Open Graph -->
<meta property="og:title" content="<?php echo htmlspecialchars($og_title ?? ($title ?? 'DeepMax.ru'), ENT_QUOTES, 'UTF-8'); ?>">
<meta property="og:description" content="<?php echo htmlspecialchars($og_description ?? ($description ?? 'Информация о ценных бумагах'), ENT_QUOTES, 'UTF-8'); ?>">
<meta property="og:image" content="<?php echo SITE_URL; ?>images/<?php echo $og_image ?? 'sectors_img.gif'; ?>">
<meta property="og:image:alt" content="<?php echo htmlspecialchars($og_image_alt ?? 'DeepMax.ru', ENT_QUOTES, 'UTF-8'); ?>">
<meta property="og:url" content="<?php echo SITE_URL . ($og_url ?? ''); ?>">
<?php
// Определяем og:type в зависимости от типа страницы
$og_type = 'website'; // по умолчанию для sectors, emitents и т.д.
if (isset($page_type)) {
    // Для страниц финансовых инструментов (все 6 типов) - используем "product"
    // ВАЖНО: Массив в UPPERCASE т.к. page.php возвращает типы в UPPERCASE
    $financial_instruments = ['STOCK', 'RECEIPT', 'EUROBOND', 'FUND', 'MORTGAGE_NOTE', 'BOND'];
    if (in_array($page_type, $financial_instruments)) {
        $og_type = 'product';
    }
}
?>
<meta property="og:type" content="<?php echo $og_type; ?>">
<meta property="og:site_name" content="<?php echo defined('SITE_NAME') ? SITE_NAME : 'DeepMax.ru'; ?>">
<meta property="og:locale" content="ru_RU">
<meta property="og:updated_time" content="<?php echo isset($lastModified) ? date('c', strtotime($lastModified)) : date('c'); ?>">

<!-- Twitter -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="<?php echo htmlspecialchars($og_title ?? ($title ?? 'DeepMax.ru'), ENT_QUOTES, 'UTF-8'); ?>">
<meta name="twitter:description" content="<?php echo htmlspecialchars($og_description ?? ($description ?? 'Информация о ценных бумагах'), ENT_QUOTES, 'UTF-8'); ?>">
<meta name="twitter:image" content="<?php echo SITE_URL; ?>images/sectors_img.gif">

<!-- Favicon -->
<link rel="icon" type="image/png" sizes="256x256" href="/favicon.png">
<link rel="shortcut icon" href="/favicon.ico" type="image/x-icon">

<!-- Стили -->
<!-- ═══════════════════════════════════════════════════════════════
     CRITICAL CSS v9.2.0 - Inline для мгновенного рендеринга
     Above-the-fold стили всех типов страниц (23 KB)
     ═══════════════════════════════════════════════════════════════ -->
<style>
<?php
// Инлайнинг critical CSS для устранения FOUC
$critical_css_path = '/var/www/www-root/data/www/deepmax.ru/css-modules/dist/critical.min.css';
if (file_exists($critical_css_path)) {
    echo file_get_contents($critical_css_path);
}
?>
</style>

<?php
// ═══════════════════════════════════════════════════════════════
// ASYNC LOADING - Core CSS + Page-specific CSS
// ═══════════════════════════════════════════════════════════════

// 1. Core CSS - асинхронная загрузка (дополнительные компоненты)
echo '<link rel="preload" href="/css-modules/dist/core.min.css?v=9.2.0" as="style" onload="this.onload=null;this.rel=\'stylesheet\'">' . "\n";
echo '<noscript><link rel="stylesheet" href="/css-modules/dist/core.min.css?v=9.2.0"></noscript>' . "\n";

// 2. Page-specific CSS - асинхронная загрузка
if (isset($page_type) && !empty($page_type)) {
    $page_type_lower = strtolower($page_type);
    
    // Маппинг типов страниц на CSS файлы
    $css_map = [
        // Основные типы
        'bond' => 'bond',
        'stock' => 'stock',
        'emitent' => 'emitent',
        'sector' => 'sector',
        
        // Специальные типы (используют базовые стили)
        'eurobond' => 'bond',
        'mortgage_note' => 'bond',
        'fund' => 'stock',
        'receipt' => 'stock'
    ];
    
    $css_file = $css_map[$page_type_lower] ?? null;
    
    // Для типа 'menu' определяем CSS по имени файла
    if ($page_type_lower === 'menu' && isset($page_data[1]->MENU_file_include)) {
        $menu_file = basename($page_data[1]->MENU_file_include, '.php');
        
        $menu_css_map = [
            'bonds-catalog' => 'catalog-bonds',
            'stocks-catalog' => 'catalog-stocks',
            'emitents-catalog' => 'catalog-emitents',
            'sectors' => 'sectors'
        ];
        
        $css_file = $menu_css_map[$menu_file] ?? null;
    }
    
    if ($css_file) {
        $css_path = "/css-modules/dist/pages/{$css_file}.min.css";
        
        // Проверяем что файл существует
        if (file_exists('/var/www/www-root/data/www/deepmax.ru' . $css_path)) {
            echo '<link rel="preload" href="' . $css_path . '?v=9.2.0" as="style" onload="this.onload=null;this.rel=\'stylesheet\'">' . "\n";
            echo '<noscript><link rel="stylesheet" href="' . $css_path . '?v=9.2.0"></noscript>' . "\n";
        }
    }
}
?>

<?php
// ═══════════════════════════════════════════════════════════════
// DEBUG CSS LOADING - ВРЕМЕННАЯ ДИАГНОСТИКА
// ═══════════════════════════════════════════════════════════════
echo "\n<!-- DEBUG CSS LOADING:\n";
echo "page_type: " . (isset($page_type) ? var_export($page_type, true) : 'NOT SET') . "\n";
echo "page_type type: " . (isset($page_type) ? gettype($page_type) : 'N/A') . "\n";

if (isset($page_data) && is_array($page_data)) {
    echo "page_data: ARRAY with " . count($page_data) . " elements\n";
    echo "page_data[0]: " . (isset($page_data[0]) ? var_export($page_data[0], true) : 'NOT SET') . "\n";
    
    if (isset($page_data[1])) {
        echo "page_data[1]: EXISTS (type: " . gettype($page_data[1]) . ")\n";
        
        if (is_object($page_data[1])) {
            $props = get_object_vars($page_data[1]);
            echo "page_data[1] properties: " . implode(', ', array_keys($props)) . "\n";
            
            if (isset($page_data[1]->MENU_file_include)) {
                echo "MENU_file_include: " . $page_data[1]->MENU_file_include . "\n";
                echo "basename result: " . basename($page_data[1]->MENU_file_include, '.php') . "\n";
            } else {
                echo "MENU_file_include: NOT SET\n";
            }
        }
    } else {
        echo "page_data[1]: NOT EXISTS\n";
    }
} else {
    echo "page_data: " . (isset($page_data) ? 'NOT ARRAY' : 'NOT SET') . "\n";
}

echo "sectors.min.css exists: " . (file_exists('/var/www/www-root/data/www/deepmax.ru/css-modules/dist/pages/sectors.min.css') ? 'YES' : 'NO') . "\n";
echo "-->\n";
?>

<!-- Schema.org разметка -->
<?php
// ✅ АКТИВНО: Schema.org JSON-LD генерируется в content.php v4.8.4 ENTERPRISE
// Используется BreadcrumbBuilder v6.1.1 PRODUCTION READY + SchemaOrg классы
//
// Реализованные типы Schema.org:
// 1. BreadcrumbList - навигационные крошки (на всех страницах)
// 2. FinancialProduct - страницы акций (SchemaOrgEquity v1.2) - types 1, 2, 4
// 3. FinancialProduct - страницы облигаций (SchemaOrgDebt v1.1) - types 3, 5, 6
// 4. Organization - страницы эмитентов (SchemaOrgEmitent v1.1)
// 5. CollectionPage - страницы секторов (SchemaOrgSector v1.0)
//
// Все классы внедрены на production и протестированы через Google Rich Results Test
?>

<!-- Яндекс Метрика -->
<meta name="yandex-verification" content="ad45195f5cd8906e">

</head>
<body class="site site-lang-ru">
<!-- Skip link для screen readers и keyboard navigation -->
<a href="#main-content" class="skip-link">Перейти к основному содержимому</a>
<div class="site-wrapper">
<?php
/**
 * ВАЖНО: Закрывающие теги </div></body></html> находятся в footer.php
 * НЕ закрывайте их здесь!
 * 
 * Структура:
 * - head.php: открывает <html>, <head>, <body>, <div class="site-wrapper">
 * - header.php: <header> с меню
 * - content.php: <main> с контентом
 * - footer.php: <footer> + закрывает </div></body></html>
 */
?>