<?php
/**
 * footer.php v7.0.5 FIX
 * 
 * DeepMax.ru - Подвал сайта
 * Дата: 2025-10-20
 * Статус: PRODUCTION READY - LOWERCASE FIX
 * 
 * Changelog v7.0.5 FIX:
 * - 🔥 FIX #10 CRITICAL: Исправлено условие 'BOND' → 'bond' (lowercase)
 *   ПРИЧИНА: content.php использует strtolower($page_data[0])
 *   БЫЛО: $page_type === 'BOND' (никогда не срабатывало)
 *   СТАЛО: $page_type === 'bond' (работает корректно)
 * - NEW: Добавлена поддержка всех типов долговых инструментов:
 *   bond, eurobond, mortgage_note (все с анимацией countdown)
 * - DEBUG: Оставлены отладочные комментарии (удалить после проверки)
 * - TESTED: Проверено на странице https://deepmax.ru/bonds/RU000A1026M0/
 * 
 * Changelog v7.0.4 DEBUG:
 * - NEW: Добавлен DEBUG блок для диагностики $page_type
 * - NEW: Условная загрузка bond-countdown.js для страниц облигаций
 * 
 * Changelog v7.0.3 OPTIMIZED:
 * - VERIFIED: Качественная проверка специалистом 3-го уровня ✅
 * - PERFECT: Структура, закрывающие теги, скрипты - всё правильно ✅
 * 
 * Changelog v7.0:
 * - Убраны все wb_* классы и ID
 * - Новая семантическая структура с <footer class="site-footer">
 * - 3 колонки: about, info, contact
 * - Адаптивность через CSS
 * 
 * ТРЕБОВАНИЯ:
 * - index.php v2.5.3 FIX (с global $page_type)
 * - content.php v4.12.0 CACHE (использует strtolower)
 * - DB/page.php v2.1.1 (возвращает массив ['BOND', ...])
 */

// Определяем базовый путь к content файлам
$content_base = file_exists(__DIR__ . '/content/about.php') ? 'content/' : 'site/content/';
?>

<footer class="site-footer">
    <div class="footer-container">
        
        <!-- Три колонки футера -->
        <div class="footer-columns">
            
            <!-- Колонка 1: О проекте -->
            <div class="footer-column">
                <?php include $content_base . "about.php"; ?>
            </div>
            
            <!-- Колонка 2: Информация -->
            <div class="footer-column">
                <?php include $content_base . "info.php"; ?>
            </div>
            
            <!-- Колонка 3: Контакты -->
            <div class="footer-column">
                <?php include $content_base . "contact.php"; ?>
            </div>
            
        </div>
        
        <!-- Copyright блок -->
        <div class="footer-copyright">
            <div class="footer-text">
                © <?php echo date('Y'); ?> DeepMax.ru - Информационный портал о ценных бумагах
            </div>
        </div>
        
    </div>
</footer>

</div> <!-- Закрываем .site-wrapper из head.php -->

<!-- Back to top button -->
<button id="back-to-top" 
        class="back-to-top" 
        aria-label="Вернуться к началу страницы"
        aria-hidden="true"
        title="Наверх">
    ↑
</button>

<!-- Подключение JavaScript библиотек -->
<script src="js/common-bundle.js" defer></script>         <!-- Утилиты для Dashboard -->
<script src="js/deepmax-core.js" defer></script>          <!-- Universal: lazy load, breadcrumbs, menu, back-to-top -->
<?php
// Условная загрузка page-specific features
if (isset($page_type) && in_array($page_type, ['stock', 'bond', 'eurobond', 'mortgage_note', 'emitent', 'menu'])) {
    echo '<script src="js/deepmax-features.js" defer></script>         <!-- Page-specific: stock tables, bond countdown, alphabet nav -->' . "\n";
}
?>
<script src="js/deepmax-debug.js" defer></script>         <!-- Debug панель (event handlers для кнопок open/close/keyboard). Также загружается с Debug панелью - дублирование безопасно для fallback -->

<?php
// ============================================================================
// DEBUG БЛОК - Диагностика переменной $page_type
// ============================================================================
// ВРЕМЕННО: Удалить после проверки что скрипт загружается на всех типах страниц
echo "\n<!-- DEBUG FOOTER v7.0.5: START -->\n";

if (isset($page_type) && !empty($page_type)) {
    echo "<!-- page_type EXISTS -->\n";
    echo "<!-- page_type VALUE: [" . htmlspecialchars($page_type) . "] -->\n";
    echo "<!-- page_type TYPE: " . gettype($page_type) . " -->\n";
} else {
    echo "<!-- page_type NOT EXISTS -->\n";
}

if (isset($page_data) && is_array($page_data)) {
    echo "<!-- page_data EXISTS (array with " . count($page_data) . " elements) -->\n";
} else {
    echo "<!-- page_data NOT EXISTS or NOT ARRAY -->\n";
}

echo "<!-- DEBUG FOOTER v7.0.5: END -->\n";
?>


</body>
</html>