#!/bin/bash
echo "═══════════════════════════════════════════════════════════"
echo "  ИТОГОВАЯ ПРОВЕРКА ВСЕХ МОДУЛЕЙ"
echo "═══════════════════════════════════════════════════════════"
echo ""

total_open=0
total_close=0
total_lines=0

echo "PAGE MODULES:"
echo "───────────────────────────────────────────────────────────"
for file in pages/*.css; do
    name=$(basename "$file")
    lines=$(wc -l < "$file")
    open=$(grep -c "{" "$file" || echo "0")
    close=$(grep -c "}" "$file" || echo "0")
    
    total_lines=$((total_lines + lines))
    total_open=$((total_open + open))
    total_close=$((total_close + close))
    
    if [ "$open" -eq "$close" ]; then
        status="✓"
    else
        status="✗"
    fi
    
    printf "%-25s %5s строк | %3s={%3s} %s\n" "$name" "$lines" "$open" "$close" "$status"
done

echo ""
echo "CORE MODULE:"
echo "───────────────────────────────────────────────────────────"
file="build/core-full.css"
name=$(basename "$file")
lines=$(wc -l < "$file")
open=$(grep -c "{" "$file")
close=$(grep -c "}" "$file")

total_lines=$((total_lines + lines))
total_open=$((total_open + open))
total_close=$((total_close + close))

if [ "$open" -eq "$close" ]; then
    status="✓"
else
    status="✗"
fi

printf "%-25s %5s строк | %3s={%3s} %s\n" "$name" "$lines" "$open" "$close" "$status"

echo ""
echo "═══════════════════════════════════════════════════════════"
echo "  ИТОГО"
echo "═══════════════════════════════════════════════════════════"
echo "Всего строк:       $total_lines"
echo "Всего скобок:      $total_open={$total_close}"
echo ""
echo "Исходный best.css: 5188 строк, 765 скобок"
echo "Разница строк:     $((total_lines - 5188))"
echo "Разница скобок:    $((total_open - 765))={$((total_close - 765))}"
echo ""

if [ "$total_open" -eq "$total_close" ] && [ "$total_open" -eq 765 ]; then
    echo "✅ ВСЕ МОДУЛИ ВАЛИДНЫ!"
else
    echo "❌ ОШИБКА В БАЛАНСЕ СКОБОК!"
fi
